% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_vboot.R
\name{vboot}
\alias{vboot}
\title{Generic function for bootstrap validation}
\usage{
vboot(glmnet_fit, x, y, s, nfolds = 5, B = 200, cv_replicates = 100,
  n_cores = max(1, parallel::detectCores() - 1))
}
\arguments{
\item{glmnet_fit}{Object from glmnet fit}

\item{x}{A matrix of the predictors, each row is an observation vector.}

\item{y}{A vector of response variable. It can be numeric or factor with two levels}

\item{s}{Value of the penalty parameter "lambda" selected from the original cv.glmnet}

\item{nfolds}{Number of folds for cross validation as in cv.glmnet}

\item{B}{Number of bootsrap samples}

\item{cv_replicates}{Number of replicates for the cross-validation step}

\item{n_cores}{number of cores to use in parallel. Default detectCores()-1}
}
\description{
Validate 'glmnet' linear or logistic regression using bootstrap.
}
\examples{
# Create the data
set.seed(25)
x <- matrix(rnorm(80),ncol=4)
y <- x[,4]*0.8+x[,3]*0.4+rnorm(20)
# Fit glmnet model
fit_enet <- glmnet::glmnet(x, y, alpha = 0.5)
# Bootstrap validation
vboot(fit_enet, x, y, nfolds = 3, B = 2, s = 0.5, cv_replicates = 5, n_cores = 1)
}
\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010). Regularization Paths for Generalized Linear Models via Coordinate Descent. Journal of Statistical Software, 33(1), 1-22. URL http://www.jstatsoft.org/v33/i01/.

Frank Harrell (2015). Harrell Jr, F. E. (2015). Regression modeling strategies: with applications to linear models, logistic and ordinal regression, and survival analysis. Springer.
}
