% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLM.R
\name{predict.BranchGLM}
\alias{predict.BranchGLM}
\title{Predict Method for BranchGLM Objects}
\usage{
\method{predict}{BranchGLM}(object, newdata = NULL, type = "response", ...)
}
\arguments{
\item{object}{a \code{BranchGLM} object.}

\item{newdata}{a dataframe, if not specified the data the model was fit on is used.}

\item{type}{one of "linpreds" or "response", if not specified "response" is used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A numeric vector of predictions.
}
\description{
Gets predictions from a \code{BranchGLM} object.
}
\details{
linpreds corresponds to the linear predictors and response is on the scale of the response variable.
Offset variables are ignored for predictions on new data.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")
predict(Fit)
### Example with new data
predict(Fit, newdata = iris[1:20,])
}
