% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_observations.R
\name{get_observations}
\alias{get_observations}
\title{Run an algorithm on a problem.}
\usage{
get_observations(algo, instance, n = 1)
}
\arguments{
\item{algo}{a list object containing the definitions of the algorithm.
See \code{\link[=calc_nreps2]{calc_nreps2()}} for details.}

\item{instance}{a list object containing the definitions of the problem
instance. See \code{\link[=calc_nreps2]{calc_nreps2()}} for details.}

\item{n}{number of observations to generate.}
}
\value{
vector of observed performance values
}
\description{
Call algorithm routine for the solution of a problem instance
}
\examples{
algorithm <- list(FUN = "dummyalgo", alias = "myalgo",
                  distribution.fun = "rnorm",
                  distribution.pars = list(mean = 50, sd = 10))
instance <- list(FUN = "dummyinstance")
x <- get_observations(algorithm, instance, n = 1000)
hist(x)
}
\seealso{
\link{calc_nreps2}
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
