% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{measure_sgrna_stats}
\alias{measure_sgrna_stats}
\title{A function to perform a statistical test at a sgRNA-level}
\usage{
measure_sgrna_stats(
  sgcount,
  design,
  group_a,
  group_b,
  delim = "_",
  ge_id = NULL,
  sg_id = NULL
)
}
\arguments{
\item{sgcount}{This data frame contains read counts of sgRNAs for the samples.}

\item{design}{This table contains study design. It has to contain `group.`}

\item{group_a}{The first group to be tested.}

\item{group_b}{The second group to be tested.}

\item{delim}{The delimiter between a gene name and a sgRNA ID. It will be used if only rownames contains sgRNA ID.}

\item{ge_id}{The column name of the gene column.}

\item{sg_id}{The column/columns of sgRNA identifiers.}
}
\value{
A table contains the sgRNA-level test result, and the table contains these columns: 
\itemize{
 \item `sgRNA': The sgRNA identifier.
 \item `gene': The gene is the target of the sgRNA 
 \item `n_a': The number of replicates of the first group.
 \item `n_b': The number of replicates of the second group.
 \item `phat_a': The proportion value of the sgRNA for the first group.
 \item `phat_b': The proportion value of the sgRNA for the second group.
 \item `vhat_a': The variance of the sgRNA for the first group.
 \item `vhat_b': The variance of the sgRNA for the second group.
 \item `cpm_a': The mean CPM of the sgRNA within the first group.
 \item `cpm_b': The mean CPM of the sgRNA within the second group.
 \item `logFC': The log fold change of sgRNA between two groups.
 \item `t_value': The value for the t-statistics.
 \item `df': The value of the degree of freedom, and will be used to calculate the p-value of the sgRNA.
 \item `p_ts': The p-value indicates a difference between the two groups.
 \item `p_pa': The p-value indicates enrichment of the first group.
 \item `p_pb': The p-value indicates enrichment of the second group.
 \item `fdr_ts': The adjusted P-value of `p_ts'.
 \item `fdr_pa': The adjusted P-value of `p_pa'.
 \item `fdr_pb': The adjusted P-value of `p_pb'.
}
}
\description{
A function to perform a statistical test at a sgRNA-level
}
\examples{
library(CB2)
data(Evers_CRISPRn_RT112)
measure_sgrna_stats(Evers_CRISPRn_RT112$count, Evers_CRISPRn_RT112$design, "before", "after")

}
