% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBMSM.R
\name{CBMSM.fit}
\alias{CBMSM.fit}
\title{CBMSM.fit}
\usage{
CBMSM.fit(treat, X, id, time, MultiBin.fit, twostep, msm.variance,
  time.vary, init, ...)
}
\arguments{
\item{treat}{A vector of treatment assignments.  For N observations over T
time periods, the length of treat should be N*T.}

\item{X}{A covariate matrix.  For N observations over T time periods, X
should have N*T rows.}

\item{id}{A vector which identifies the unit associated with each row of
treat and X.}

\item{time}{A vector which identifies the time period associated with each
row of treat and X.}

\item{MultiBin.fit}{A parameter for whether the multiple binary treatments
occur concurrently (\code{FALSE}) or over consecutive time periods
(\code{TRUE}) as in a marginal structural model.  Setting type = "MultiBin"
when calling \code{CBMSM} will set MultiBin.fit to \code{TRUE} when
CBMSM.fit is called.}

\item{twostep}{Set to \code{TRUE} to use a two-step estimator, which will
run substantially faster than continuous-updating.  Default is \code{FALSE},
which uses the continuous-updating estimator described by Imai and Ratkovic
(2014).}

\item{msm.variance}{Default is \code{FALSE}, which uses the low-rank
approximation of the variance described in Imai and Ratkovic (2014).  Set to
\code{TRUE} to use the full variance matrix.}

\item{time.vary}{Default is \code{FALSE}, which uses the same coefficients
across time period.  Set to \code{TRUE} to fit one set per time period.}

\item{init}{Default is \code{"opt"}, which uses CBPS and logistic regression
starting values, and chooses the one that achieves the best balance.  Other options 
are "glm" and "CBPS"}

\item{...}{Other parameters to be passed through to \code{optim()}}
}
\description{
CBMSM.fit
}
