% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_SSMUs}
\alias{load_SSMUs}
\title{Load CCAMLR Small Scale Management Units}
\usage{
load_SSMUs()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
}
\examples{
 
\donttest{

#When online:
SSMUs=load_SSMUs()
plot(st_geometry(SSMUs))

#If going offline in the future: load and save as RData when online,
#then reload RData when offline:
SSMUs=load_SSMUs()
EEZs=load_EEZs()
#N.B.: replace tempdir() with folder location of your choice
save(list=c('SSMUs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(SSMUs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
