% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{cdec_query}
\alias{cdec_query}
\title{Query observation data}
\usage{
cdec_query(station, sensor_num = NULL, dur_code = NULL, start_date = NULL,
  end_date = NULL)
}
\arguments{
\item{station}{three letter identification for CDEC location (example "KWK", "SAC", "CCR")}

\item{sensor_num}{sensor number for the measure of interest. (example "20", "01", "25")}

\item{dur_code}{duration code for measure interval, "E", "H", "D", which correspong to Event, Hourly and Daily.}

\item{start_date}{date to start the query on.}

\item{end_date}{a date to end query on, defaults to current date.}
}
\value{
tidy dataframe
}
\description{
Function queries the CDEC site to obtain desired station data
based on station, sensor number, duration code and start/end date.
Use cdec_datasets() to view an updated list of all available data at a station.
}
\examples{
kwk_hourly_flows <- CDECRetrieve::cdec_query("KWK", "20", "H", "2017-01-01")
ccr_hourly_temps <- CDECRetrieve::cdec_query("CCR", "25", "H", Sys.Date())
}
