% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbConnectDetails.R
\name{dbConnect,dbConnectDetails-method}
\alias{dbConnect,dbConnectDetails-method}
\title{Connect to a database using stored connection details}
\usage{
\S4method{dbConnect}{dbConnectDetails}(drv)
}
\arguments{
\item{drv}{An dbConnectDetails object created by \code{dbConnectDetails()}}
}
\value{
An S4 object that inherits from DBIConnection used to communicate
with the database engine.
}
\description{
Create connection details, save them in an object, and use them to connect
to a database using dbConnect later during program execution.
}
\examples{
\dontrun{
library(DBI)
connectionDetails <- dbConnectDetails(RPostgres::Postgres(),
                                      dbname = "cdm",
                                      host = "localhost",
                                      user = "postgres",
                                      password = Sys.getenv("password"))

 selfContainedQuery <- function(dbConnectDetails) {
   con <- dbConnect(connectionDetails)
   on.exit(dbDisonnect(con))
   dbGetQuery(con, "select count(*) as n from synthea1k.person")
 }

selfContainedQuery(connectionDetails)
}

}
