% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/W_func_GLM.R
\name{W_func_GLM}
\alias{W_func_GLM}
\title{Calculate the diagonal elements nu of Fisher information matrix}
\usage{
W_func_GLM(X, beta, link = "logit")
}
\arguments{
\item{X}{Model matrix}

\item{beta}{Parameters of GLM model}

\item{link}{GLM link function, default is "logit", options are "logit", "probit", "cloglog", "loglog", "identity", identity is the same as ordinary linear regression}
}
\value{
the diagonal element nu of GLM Fisher information matrix, can be used as w in liftone_constrained_GLM
}
\description{
Calculate the diagonal elements nu of Fisher information matrix
}
\examples{
beta = c(0, 3, 3, 3) #main effect model beta_0, beta_1, beta_21, beta_22
#gives the 6 categories (0,0,0), (0,1,0),(0,0,1),(1,0,0),(1,1,0),(1,0,1)
X.liftone=matrix(data=c(1,0,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,0,1), ncol=4, byrow=TRUE)
#calculate diagonal elements of W based on beta's under logit link
W=W_func_GLM(X= X.liftone, beta=beta, link="logit")

}
