% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotheat}
\alias{CGGPplotheat}
\title{Heatmap of SG design depth}
\usage{
CGGPplotheat(CGGP)
}
\arguments{
\item{CGGP}{CGGP object}
}
\value{
A heat map made from ggplot2
}
\description{
The values on the diagonal are largest design depth for that dimension.
The off-diagonal values are the largest design depth that both dimensions
have been measured at simultaneously.
A greater depth means that more points have been measured along that
dimension or two-dimensional subspace.
}
\examples{
\donttest{
# All dimensions should look similar
d <- 8
SG = CGGPcreate(d,201)
CGGPplotheat(SG)

# The first and fourth dimensions are most active and will have greater depth
SG <- CGGPcreate(d=5, batchsize=50)
f <- function(x) {cos(2*pi*x[1]*3) + exp(4*x[4])}
for (i in 1:1) {
  SG <- CGGPfit(SG, Y=apply(SG$design, 1, f))
  SG <- CGGPappend(CGGP=SG, batchsize=200)
}
# SG <- CGGPfit(SG, Y=apply(SG$design, 1, f))
CGGPplotheat(SG)
}
}
\references{
https://stackoverflow.com/questions/14290364/heatmap-with-values-ggplot2
}
\seealso{
Other CGGP plot functions: 
\code{\link{CGGPplotblocks}()},
\code{\link{CGGPplotcorr}()},
\code{\link{CGGPplothist}()},
\code{\link{CGGPplotsamplesneglogpost}()},
\code{\link{CGGPplotslice}()},
\code{\link{CGGPplottheta}()},
\code{\link{CGGPplotvariogram}()},
\code{\link{CGGPvalplot}()}
}
\concept{CGGP plot functions}
