% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PostProcess.R
\name{plot_simulationMatrixWithCI}
\alias{plot_simulationMatrixWithCI}
\title{plot_simulationMatrixWithCI}
\usage{
plot_simulationMatrixWithCI(
  simulationMatrix,
  independentVariableVector = NA,
  dependentVariableTypeVector = NA,
  confidenceLevels = c(0.25, 0.75),
  observationVector = NA,
  observationIndpendentVariableVector = NA,
  observationDependentVariableTypeVector = NA
)
}
\arguments{
\item{simulationMatrix}{(required input) \emph{A matrix of numbers} where each row contains the simulated values that will be plotted.}

\item{independentVariableVector}{(default: NA) \emph{A vector of numbers} that represents the independent variables of each points of the simulation (e.g., observation time) where used for the values of x-axis when plotting. If set at NA then sequence of 1,2,3,... will be used.}

\item{dependentVariableTypeVector}{(default: NA) \emph{A vector of strings} specify the kind of variable the simulation values are. (i.e., if it simulate both PK and PD then indicate which simulation value is PK and which is PD).}

\item{confidenceLevels}{(default: c(25,75)) \emph{A vector of two numbers between 0 and 1} set the confidence interval that will be used for the plot.  Default is inter-quartile range.}

\item{observationVector}{(default: NA) \emph{A vector of numbers} used when wishing to overlay the plot of observations to the simulation.}

\item{observationIndpendentVariableVector}{(default: NA) \emph{A vector of numbers} used when wishing to overlay the plot of observations to the simulation.}

\item{observationDependentVariableTypeVector}{(default: NA) \emph{A vector of numbers} used when wishing to overlay the plot of observations to the simulation.}
}
\value{
\emph{A ggplot object} including the violin plot, interquartile range and median, minimum and maximum.
}
\description{
Plot simulation that are provided to plot confidence interval (or more like a confidence region).
}
\examples{
\dontrun{
model_analytic_function=function(x){

 observation_time=c(0.1,0.2,0.4,0.6,1,2,3,6,12)
 Dose=1000
 F=1

 ka=x[1]
 V1=x[2]
 CL_2=x[3]
 t=observation_time

 Cp=ka*F*Dose/(V1*(ka-CL_2/V1))*(exp(-CL_2/V1*t)-exp(-ka*t))

 (Cp)
}

observation=(c(4.91, 8.65, 12.4, 18.7, 24.3, 24.5, 18.4, 4.66, 0.238))

CGNM_result=Cluster_Gauss_Newton_method(
nonlinearFunction=model_analytic_function,
targetVector = observation, num_iteration = 10, num_minimizersToFind = 100,
initial_lowerRange = c(0.1,0.1,0.1), initial_upperRange =  c(10,10,10),
lowerBound=rep(0,3), ParameterNames=c("Ka","V1","CL_2"), saveLog = FALSE)

CGNM_bootstrap=Cluster_Gauss_Newton_Bootstrap_method(CGNM_result,
     nonlinearFunction=model_analytic_function, num_bootstrapSample=100)


plot_simulationMatrixWithCI(CGNM_result$bootstrapY,
independentVariableVector=observation_time, observationVector=observation)
}
}
