## speciation of phosphate as a function of ionic strength
opar <- par(mfrow=c(2, 1))
basis("CHNOPS+")
T <- c(25, 100)
species(c("PO4-3", "HPO4-2", "H2PO4-"))
a25 <- affinity(IS=c(0, 0.14), T=T[1])
e25 <- equilibrate(a25)
d25 <- diagram(e25, ylim=c(-3.0, -2.6), legend.x=NULL)
a100 <- affinity(IS=c(0, 0.14), T=T[2])
e100 <- equilibrate(a100)
d100 <- diagram(e100, ylim=c(-3.0, -2.6), add=TRUE, col="red")  
title(main="Non-ideality model for phosphate species")
dp <- describe.property(c("pH", "T", "T"), c(7, T))
legend("topright", lty=c(NA, 1, 1), col=c(NA, "black", "red"), legend=dp)
text(0.07, -2.76, expr.species("HPO4-2"))
text(0.07, -2.90, expr.species("H2PO4-"))
# the crossing points of the logarithms of activity at the two temperatures
# (it's higher IS at higher temperature)
x25 <- which.min(abs(d25$loga.equil[[3]] - d25$loga.equil[[2]]))
stopifnot(all.equal(x25, 27))
x100 <- which.min(abs(d100$loga.equil[[3]] - d100$loga.equil[[2]]))
stopifnot(all.equal(x100, 45))
## phosphate predominance f(IS,pH)
a <- affinity(IS=c(0, 0.14), pH=c(6, 13), T=T[1])
d <- diagram(a, fill=NULL)
a <- affinity(IS=c(0, 0.14), pH=c(6, 13), T=T[2])
d <- diagram(a, add=TRUE, names=NULL, col="red")
par(opar)
# the most stable species are PO4-3, HPO4-2, H2PO4- with decreasing pH,
# at any ionic strength (in the range used here)
stopifnot(all.equal(unique(d$predominant[1, 1:128]), 3:1))
stopifnot(all.equal(unique(d$predominant[128, 1:128]), 3:1))
