% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMF.R
\name{predictCMF}
\alias{predictCMF}
\title{Predict with CMF}
\usage{
predictCMF(X, model)
}
\arguments{
\item{X}{A list of sparse matrices specifying the indices for which to
make the predictions.
These matrices must correspond to the structure used for \code{X}
when learning the model with \code{CMF}.}

\item{model}{A list of model parameter values provided by \code{CMF}.}
}
\value{
A list of
\item{out}{A list of matrices corresponding to predictions for each
           matrix in \code{X}.}
\item{error}{A vector containing the root-mean-square error for each
             matrix separately.}
}
\description{
Code for predicting missing elements with an existing CMF model.
The predictions are made for all of the elements specified in the list of
input matrices \code{X}. The function also returns the root mean square
error (RMSE) between the predicted outputs and the values provided in
\code{X}.
}
\details{
Note that \code{X} needs to be provided as a set of triplets instead of as
a regular matrix. See \code{\link{matrix_to_triplets}}.
}
\examples{

# See CMF-package for an example.

}
\author{
Arto Klami and Lauri Väre
}
