% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_jam.R
\docType{data}
\name{jam}
\alias{jam}
\title{Jam data}
\format{
A data frame with 24 rows and four columns.
\describe{
\item{type}{the type of jam that was tested}
\item{judge}{the judge that was used for tasting}
\item{sweetness}{the judges score for sweetness: 1 denotes not sweet
enough, 2 not quite sweet enough, 3 just about right, 4 a little too sweet
and 5 too sweet}
\item{sweetness_ranks}{the ranks within judge}
}
}
\source{
Rayner and Best (2017, 2018)
}
\usage{
data(jam)
}
\description{
Plum jam sweetness data based on JAR judge scores.
}
\details{
Three plum jams, A, B and C are given JAR sweetness codes by eight judges.
Here, 1 denotes not sweet enough, 2 not quite sweet enough, 3 just about
right, 4 a little too sweet and 5 too sweet.
}
\examples{
attach(jam)
a_ij = matrix(rep(1:3,8), ncol = 8)
b_hj = matrix(rep(1:5,8), ncol = 8)
CMH(treatment = type, response = sweetness, strata = judge,
    a_ij = a_ij, b_hj = b_hj, test_OPA = FALSE, test_GA = FALSE,
    test_MS = FALSE)
}
\references{
Rayner, J.C.W. and Best, D.J. (2017). Unconditional analogues of Cochran-Mantel-Haenszel tests. Australian & NZ Journal of Statistics, 59(4), 485-494.

Rayner, J.C.W. and Best, D.J. (2018). Extensions to the Cochran-Mantel-Haenszel mean scores and correlation tests. Journal of Statistical Theory and Practice.
}
\keyword{RBD}
\keyword{datasets}
\keyword{jam}
