% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_cof_excl_ehv_132kv_tf.R
\name{n_cof_excl_ehv_132kv_tf}
\alias{n_cof_excl_ehv_132kv_tf}
\title{Network cost of Failure for all Assets Categories excl.
EHV and 132kV Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
n_cof_excl_ehv_132kv_tf(
  asset_type_ncf,
  no_customers,
  kva_per_customer = "Default"
)
}
\arguments{
\item{asset_type_ncf}{String.
\code{asset_type_ncf = c("LV Poles", "LV Circuit Breaker",
"LV Pillar (ID)", "LV Pillar (OD at Substation)",
"LV Pillar (OD not at a Substation)", "LV Board (WM)",
"LV UGB", "LV Board (X-type Network) (WM)", "6.6/11kV Poles",
"20kV Poles", "HV Sub Cable", "6.6/11kV CB (GM) Primary",
"6.6/11kV CB (GM) Secondary", "6.6/11kV Switch (GM)", "6.6/11kV RMU",
"6.6/11kV X-type RMU", "20kV CB (GM) Primary", "20kV CB (GM) Secondary",
"20kV Switch (GM)", "20kV RMU", "6.6/11kV Transformer (GM)",
"20kV Transformer (GM)", "33kV Pole", "66kV Pole",
"33kV OHL (Tower Line) Conductor", "33kV Tower", "33kV Fittings",
"66kV OHL (Tower Line) Conductor", "66kV Tower", "66kV Fittings",
"33kV UG Cable (Non Pressurised)", "33kV UG Cable (Oil)",
"33kV UG Cable (Gas)", "66kV UG Cable (Non Pressurised)",
"66kV UG Cable (Oil)", "66kV UG Cable (Gas)",
"33kV CB (Air Insulated Busbars)(ID) (GM)",
"33kV CB (Air Insulated Busbars)(OD) (GM)",
"33kV CB (Gas Insulated Busbars)(ID) (GM)",
"33kV CB (Gas Insulated Busbars)(OD) (GM)", "33kV Switch (GM)",
"33kV RMU", "66kV CB (Air Insulated Busbars)(ID) (GM)",
"66kV CB (Air Insulated Busbars)(OD) (GM)",
"66kV CB (Gas Insulated Busbars)(ID) (GM)",
"66kV CB (Gas Insulated Busbars)(OD) (GM)", "33kV Transformer (GM)",
"66kV Transformer (GM)")}}

\item{no_customers}{Numeric. The numner of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 86, CNAIM, 2017).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
all asset categories exclusive the assets EHV and 132kV transformers.
(cf. section 7.6, page 83, CNAIM, 2017). Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
# Network cost of failure for a 6.6/11 kV transformer with 750 customers
# and 51 kVA per customer.
n_cof_excl_ehv_132kv_tf(asset_type_ncf = "6.6/11kV Transformer (GM)",
no_customers = 750, kva_per_customer = 51)
}
