% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultstable.R
\name{getUnitSummary}
\alias{getUnitSummary}
\title{Generate unit summary table}
\usage{
getUnitSummary(COIN, usel, aglevs)
}
\arguments{
\item{COIN}{A COIN}

\item{usel}{A selected unit code}

\item{aglevs}{The aggregation levels to display results from.}
}
\value{
A summary table as a data frame, containing scores and ranks for specified indicators/aggregates.
}
\description{
Generates a summary table for a single unit. This is mostly useful in unit reports.
}
\details{
This returns the scores and ranks for each indicator/aggregate as specified in \code{aglevs}. It orders the table so that
the highest aggregation levels are first. This means that if the index level is included, it will be first.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# generate unit summary for NZ - index and sub-indexes only
getUnitSummary(ASEM, usel ="NZL", aglevs = c(4,3))

}
\seealso{
\itemize{
\item \code{\link[=getUnitReport]{getUnitReport()}} Automatic unit report as html, pdf or Word
\item \code{\link[=getStrengthNWeak]{getStrengthNWeak()}} Top N-ranking indicators for a given unit
}
}
