% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIn.R
\name{getIn}
\alias{getIn}
\title{Get subsets of indicator data}
\usage{
getIn(
  obj,
  dset = "Raw",
  icodes = NULL,
  aglev = NULL,
  usel = NULL,
  use_group = NULL,
  justnumeric = TRUE
)
}
\arguments{
\item{obj}{An input object. The function can handle either the COIN object, or a data frame.
The data frame should have each column as an indicator, and optional columns \code{UnitCode} and \code{UnitName} which
specify the code (or name) of each unit. Any columns except these latter two will be treated as indicators. Any other type of object will return an error.}

\item{dset}{If input is a COIN object, this specifies which data set in \code{.$Data} to use.}

\item{icodes}{An optional character vector of indicator codes to subset the indicator data. Usefully, can also refer to
an aggregation group name, and data will be subsetted accordingly. NOTE does not work with multiple aggregate group names.}

\item{aglev}{The aggregation level to take indicator data from. Integer from 1 (indicator level)
to N (top aggregation level, typically the index).}

\item{usel}{An optional unit code, or character vector of unit codes to use to filter the data. The returned data will
only include rows corresponding to the \code{usel}, unless \code{usel = NULL} (default).}

\item{use_group}{An optional grouping variable and group to filter data from. Of the format \code{list(Group_Var = Group)},
where \code{Group_Var} is a Group_ column that must be present in the selected data set, and \code{Group} is a specified group
inside that grouping variable. This filters the selected data to only include rows from the specified group. Alternatively,
this argument can work in conjunction with \code{usel}: if \code{usel} is specified, \code{use_group} may be input as a string simply
representing a group column. In that case the data will be filtered to include only rows from the group(s) which the \code{usel}
belong to. If \code{usel} is specified and \code{use_group} is specified as a list, \code{usel} will take precedence and \code{use_group}
will be ignored.}

\item{justnumeric}{Logical: if \code{TRUE}, removes any non-numeric columns from \code{ind_data_only}. Otherwise keeps all except those.}
}
\value{
A list with the following entries:
\itemize{
\item \code{.$IndCodes}  The indicator codes
\item \code{.$IndNames}  The indicator names (if a COIN object is input)
\item \code{.$ind_data} A data frame of indicator data, according to the input specifications, including any unit codes, names and groups
\item \code{.$ind_data_only} A data frame, as above, but without unit codes, names, groups.
\item \code{.$UnitCodes} Unit codes of selected data set.
\item \code{.$otype} Object type (a string: either \code{"COINobj"} or \code{"df"}).
}
}
\description{
This function does a number of things that are useful for many COINr functions and operations.
First, it checks to see what kind of input object is input. Then, it selects the indicator data
according to the specs supplied.
}
\details{
For example, specifying \code{dset = "Raw"} and \code{icodes = c("Ind1", "Ind5")}, it will return the indicator columns
named \verb{"Ind1" and "Ind5"} (if they exist), in the format described below. \code{icodes} can be indicators
or aggregation groups, and can call multiple groups.

You can also specify which aggregation level to target, using the \code{aglev} argument. See examples
below, and in particular the \href{https://bluefoxr.github.io/COINrDoc/helper-functions.html#selecting-data-sets-and-indicators}{COINr online documentation}.

As well as selection of columns, you can also filter to specific rows using unit codes as a reference, and/or
grouping variables. This is done using the \code{usel} and \code{use_group} arguments. This gives the ability to isolate
a unit inside a given group, for example.

\code{\link[=getIn]{getIn()}} is used by many COINr functions for plotting, accessing and reporting subsets of indicator data.
}
\examples{
# assemble ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# get indicator data from Social pillar
SocData <- getIn(ASEM, dset = "Raw", icodes = "Social", aglev = 1)
# Indicator codes
SocData$IndCodes
# Indicator data (no other columns)
SocData$ind_data_only

}
