% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_dist2targ}
\alias{n_dist2targ}
\title{Normalise as distance to target}
\usage{
n_dist2targ(x, targ, cap_max = FALSE)
}
\arguments{
\item{x}{A numeric vector}

\item{targ}{An target value}

\item{cap_max}{If \code{TRUE}, any value of \code{x} that exceeds \code{targ} will be assigned a score of 1, otherwise
will have a score greater than 1.}
}
\value{
Numeric vector
}
\description{
A measure of the distance of each value of \code{x} to a specified target. The formula is:
}
\details{
\deqn{ 1 - (x_{targ} - x)/(x_{targ} - x_{min}) }

Values exceeding \code{x_targ} can be optionally capped at 1 if \code{cap_max = TRUE}.
}
\examples{
x <- runif(20)
n_dist2targ(x, 0.8, cap_max = TRUE)

}
