% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{Normalise.purse}
\alias{Normalise.purse}
\title{Create normalised data sets in a purse of coins}
\usage{
\method{Normalise}{purse}(
  x,
  dset,
  global_specs = NULL,
  indiv_specs = NULL,
  directions = NULL,
  global = TRUE,
  write_to = NULL,
  ...
)
}
\arguments{
\item{x}{A purse object}

\item{dset}{The data set to normalise in each coin}

\item{global_specs}{Default specifications}

\item{indiv_specs}{Individual specifications}

\item{directions}{An optional data frame containing the following columns:
\itemize{
\item \code{iCode} The indicator code, corresponding to the column names of the data set
\item \code{Direction} numeric vector with entries either \code{-1} or \code{1}
If \code{directions} is not specified, the directions will be taken from the \code{iMeta} table in the coin, if available.
}}

\item{global}{Logical: if \code{TRUE}, normalisation is performed "globally" across all coins, by using e.g. the
max and min of each indicator in any coin. This effectively makes normalised scores comparable between coins
because they are all scaled using the same parameters. Otherwise if \code{FALSE}, coins are normalised individually.}

\item{write_to}{Optional character string for naming the data set in each coin. Data will be written to
\code{.$Data[[write_to]]}. Default is \code{write_to == "Normalised"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with new normalised data sets added at \code{.$Data$Normalised} in each coin
}
\description{
This creates normalised data sets for each coin in the purse. In most respects, this works in a similar way
to normalising on a coin, for which reason please see \code{\link[=Normalise.coin]{Normalise.coin()}} for most documentation. There is however
a special case in terms of operating on a purse of coins. This is because, when
dealing with time series data, it is often desirable to normalise over the whole panel data set at once
rather than independently for each time point. This makes the resulting index and aggregates comparable
over time. Here, the \code{global} argument controls whether to normalise each coin independently or to normalise
across all data at once. In other respects, this function behaves the same as \code{\link[=Normalise.coin]{Normalise.coin()}}.
}
\details{
The same specifications are passed to each coin in the purse. This means that each coin is normalised
using the same set of specifications and directions. If you need control over individual coins, you
will have to normalise coins individually.
}
\examples{
# build example purse
purse <- build_example_purse(up_to = "new_coin", quietly = TRUE)

# normalise raw data set
purse <- Normalise(purse, dset = "Raw", global = TRUE)

}
