% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regen.R
\name{Regen.purse}
\alias{Regen.purse}
\title{Regenerate a purse}
\usage{
\method{Regen}{purse}(x, from = NULL, quietly = TRUE, ...)
}
\arguments{
\item{x}{A purse class object}

\item{from}{Optional: a construction function name. If specified, regeneration begins from this function, rather
than re-running all functions.}

\item{quietly}{If \code{TRUE} (default), messages are suppressed during building.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Updated purse object with regenerated results.
}
\description{
Regenerates the \code{.$Data} entries in all coins by rerunning the construction functions according to the specifications in
\code{.$Log}, for each coin in the purse. This effectively regenerates the results.
}
\details{
The \code{from} argument allows partial regeneration, starting from a
specified function. This can be helpful to speed up regeneration in some cases. However, keep in mind that
if you change a \code{.$Log} argument from a function that is run before the point that you choose to start running
from, it will not affect the results.

Note that for the moment, regeneration of purses is only partially supported. This is because usually, in the
normalisation step, it is necessary to normalise across the full panel data set (see the \code{global} argument in
\code{\link[=Normalise]{Normalise()}}). At the moment, purse regeneration is performed by regenerating each coin individually, but this
does not allow for global normalisation which has to be done at the purse level. This may be fixed in future
releases.

See also documentation for \code{\link[=Regen.coin]{Regen.coin()}} and \code{vignette("adjustments")}.
}
\examples{
# see examples from Regen.coin() and vignette("adjustments")

}
