% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_get.R
\name{get_data.purse}
\alias{get_data.purse}
\title{Get subsets of indicator data}
\usage{
\method{get_data}{purse}(
  x,
  dset,
  iCodes = NULL,
  Level = NULL,
  uCodes = NULL,
  use_group = NULL,
  Time = NULL,
  also_get = NULL,
  ...
)
}
\arguments{
\item{x}{A purse class object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{iCodes}{Optional indicator codes to retrieve. If \code{NULL} (default), returns all iCodes found in
the selected data set. Can also refer to indicator groups. See details.}

\item{Level}{Optionally, the level in the hierarchy to extract data from. See details.}

\item{uCodes}{Optional unit codes to filter rows of the resulting data set. Can also be used in conjunction
with groups. See details.}

\item{use_group}{Optional group to filter rows of the data set. Specified as \code{list(Group_Var = Group)},
where \code{Group_Var} is a Group_ column that must be present in the selected data set, and \code{Group} is a specified group
inside that grouping variable. This filters the selected data to only include rows from the specified group. Can
also be used in conjunction with \code{uCodes} -- see details.}

\item{Time}{Optional time index to extract from a subset of the coins present in the purse. Should be a
vector containing one or more entries in \code{x$Time} or \code{NULL} to return all (default).}

\item{also_get}{A character vector specifying any columns to attach to the data set that are \emph{not}
indicators or aggregates. These will be e.g. \code{uName}, groups, denominators or columns labelled as "Other"
in \code{iMeta}. These columns are stored in \code{.$Meta$Unit} to avoid repetition. Set \code{also_get = "all"} to
attach all columns, or set \code{also_get = "none"} to return only numeric columns, i.e. no \code{uCode} column.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A data frame of indicator data indexed by a "Time" column.
}
\description{
This retrieves data from a purse. It functions in a similar way to \code{\link[=get_data.coin]{get_data.coin()}} but has the
additional \code{Time} argument to allow selection based on the point(s) in time.
}
\details{
Note that
}
\examples{
# build full example purse
purse <- build_example_purse(up_to = "new_coin", quietly = TRUE)

# get specified indicators for specific years, for specified units
get_data(purse, dset = "Raw",
         iCodes = c("Lang", "Forest"),
         uCodes = c("AUT", "CHN", "DNK"),
         Time = c(2019, 2020))

}
