% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr.R
\name{plot_corr}
\alias{plot_corr}
\title{Static heatmaps of correlation matrices}
\usage{
plot_corr(
  coin,
  dset,
  iCodes = NULL,
  Levels = 1,
  ...,
  cortype = "pearson",
  withparent = FALSE,
  grouplev = NULL,
  box_level = NULL,
  showvals = TRUE,
  flagcolours = FALSE,
  flagthresh = NULL,
  pval = 0.05,
  insig_colour = "#F0F0F0",
  text_colour = NULL,
  discrete_colours = NULL,
  box_colour = NULL,
  order_as = NULL,
  use_directions = FALSE
)
}
\arguments{
\item{coin}{The coin object}

\item{dset}{The target data set.}

\item{iCodes}{An optional list of character vectors where the first entry specifies the indicator/aggregate
codes to correlate against the second entry (also a specification of indicator/aggregate codes)}

\item{Levels}{The aggregation levels to take the two groups of indicators from. See \code{\link[=get_data]{get_data()}} for details.}

\item{...}{Optional further arguments to pass to \code{\link[=get_data]{get_data()}}.}

\item{cortype}{The type of correlation to calculate, either \code{"pearson"}, \code{"spearman"}, or \code{"kendall"} (see \code{\link[stats:cor]{stats::cor()}}).}

\item{withparent}{If \code{aglev[1] != aglev[2]}, and equal \code{TRUE} will only plot correlations of each row with its parent.
If \code{"family"}, plots the lowest aggregation level in \code{Levels} against all its parent levels.
If \code{FALSE} plots the full correlation matrix (default).}

\item{grouplev}{The aggregation level to group correlations by if \code{aglev[1] == aglev[2]}. By default, groups correlations into the
aggregation level above. Set to 0 to disable grouping and plot the full matrix.}

\item{box_level}{The aggregation level to draw boxes around if \code{aglev[1] == aglev[2]}.}

\item{showvals}{If \code{TRUE}, shows correlation values. If \code{FALSE}, no values shown.}

\item{flagcolours}{If \code{TRUE}, uses discrete colour map with thresholds defined by \code{flagthresh}. If \code{FALSE} uses continuous colour map.}

\item{flagthresh}{A 3-length vector of thresholds for highlighting correlations, if \code{flagcolours = TRUE}.
\code{flagthresh[1]} is the negative threshold (default -0.4). Below this value, values will be flagged red.
\code{flagthresh[2]} is the "weak" threshold (default 0.3). Values between \code{flagthresh[1]} and \code{flagthresh[2]} are coloured grey.
\code{flagthresh[3]} is the "high" threshold (default 0.9). Anything between \code{flagthresh[2]} and \code{flagthresh[3]} is flagged "OK",
and anything above \code{flagthresh[3]} is flagged "high".}

\item{pval}{The significance level for plotting correlations. Correlations with \eqn{p < pval} will be shown,
otherwise they will be plotted as the colour specified by \code{insig_colour}. Set to 0 to disable this.}

\item{insig_colour}{The colour to plot insignificant correlations. Defaults to a light grey.}

\item{text_colour}{The colour of the correlation value text (default white).}

\item{discrete_colours}{An optional 4-length character vector of colour codes or names to define the discrete
colour map if \code{flagcolours = TRUE} (from high to low correlation categories). Defaults to a green/blue/grey/purple.}

\item{box_colour}{The line colour of grouping boxes, default black.}

\item{order_as}{Optional list for ordering the plotting of variables. If specified, this must be a list of length 2, where each entry of the list is
a character vector of the iCodes plotted on the x and y axes of the plot. The plot will then follow the order of these character vectors. Note this must
be used with care because the \code{grouplev} and \code{boxlev} arguments will not follow the reordering. Hence this argument is probably best used for plots
with no grouping, or for simply re-ordering within groups.}

\item{use_directions}{Logical: if \code{TRUE} the extracted data is adjusted using directions found inside the coin (i.e. the "Direction"
column input in \code{iMeta}: any indicators with negative direction will have their values multiplied by -1 which will reverse the
direction of correlation). This should only be set to \code{TRUE} if the data set has \emph{not} yet been normalised. For example, this can be
useful to set to \code{TRUE} to analyse correlations in the raw data, but would make no sense to analyse correlations in the normalised
data because that already has the direction adjusted! So you would reverse direction twice. In other words, use this at your
discretion.}
}
\value{
A plot object generated with ggplot2, which can be edited further with ggplot2 commands.
}
\description{
Generates heatmaps of correlation matrices using ggplot2, which can be tailored according to the grouping and structure
of the index. This enables correlating any set of indicators against any other,
and supports calling named aggregation groups of indicators. The \code{withparent} argument generates tables of correlations only with
parents of each indicator. Also supports discrete colour maps using \code{flagcolours}, different types of correlation, and groups
plots by higher aggregation levels.
}
\details{
This function calls \code{\link[=get_corr]{get_corr()}}.

Note that this function can only call correlations within the same data set (i.e. only one data set in \code{.$Data}).

This function uses ggplot2 to generate plots, so the plot can be further manipulated using ggplot2 commands.
See \code{vignette("visualisation")} for more details on plotting.

This function replaces the now-defunct \code{plotCorr()} from COINr < v1.0.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "Normalise", quietly = TRUE)

# plot correlations between indicators in Sust group, using Normalised dset
plot_corr(coin, dset = "Normalised", iCodes = list("Sust"),
          grouplev = 2, flagcolours = TRUE)

}
