% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{winsorise}
\alias{winsorise}
\title{Winsorise a vector}
\usage{
winsorise(
  x,
  na.rm = FALSE,
  winmax = 5,
  skew_thresh = 2,
  kurt_thresh = 3.5,
  force_win = FALSE
)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Set \code{TRUE} to remove \code{NA} values, otherwise returns \code{NA}.}

\item{winmax}{Maximum number of points to Winsorise. Default 5. Set \code{NULL} to have no limit.}

\item{skew_thresh}{A threshold for absolute skewness (positive). Default 2.25.}

\item{kurt_thresh}{A threshold for kurtosis. Default 3.5.}

\item{force_win}{Logical: if \code{TRUE}, forces winsorisation up to winmax (regardless of skew/kurt).
Default \code{FALSE}. Note - this option should be used with care because the direction of Winsorisation
is based on the direction of skew. Successively Winsorising can switch the direction of skew and hence
the direction of Winsorisation, which may not produce the expected behaviour.}
}
\value{
A list containing winsorised data, number of winsorised points, and the individual points that
were treated.
}
\description{
Follows a "standard" Winsorisation approach: points are successively Winsorised in order to bring
skew and kurtosis thresholds within specified limits. Specifically, aims to bring absolute skew to
below a threshold (default 2.25) and kurtosis below another threshold (default 3.5).
}
\details{
Winsorisation here is defined as reassigning the point with the highest/lowest value with the value of the
next highest/lowest point. Whether to Winsorise at the high or low end of the scale is decided by the direction
of the skewness of \code{x}.

This function replaces the now-defunct \code{coin_win()} from COINr < v1.0.
}
\examples{
# numbers between 1 and 10
x <- 1:10

# two outliers
x <- c(x, 30, 100)

# winsorise
l_win <- winsorise(x, skew_thresh = 2, kurt_thresh = 3.5)

# see treated vector, number of winsorised points and details
l_win

}
