% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{SA_sample}
\alias{SA_sample}
\title{Generate sample for sensitivity analysis}
\usage{
SA_sample(N, d)
}
\arguments{
\item{N}{The number of sample points per dimension.}

\item{d}{The dimensionality of the sample}
}
\value{
A matrix with \eqn{N(d+2)} rows and \code{d} columns.
}
\description{
Generates an input sample for a Monte Carlo estimation of global sensitivity indices. Used in
the \code{\link[=get_sensitivity]{get_sensitivity()}} function. The total sample size will be \eqn{N(d+2)}.
}
\details{
This function generates a Monte Carlo sample as described e.g. in the \href{https://onlinelibrary.wiley.com/doi/book/10.1002/9780470725184}{Global Sensitivity Analysis: The Primer book}.
}
\examples{
# sensitivity analysis sample for 3 dimensions with 100 points per dimension
X <- SA_sample(100, 3)

}
\seealso{
\itemize{
\item \code{\link[=get_sensitivity]{get_sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN.
\item \code{\link[=SA_estimate]{SA_estimate()}} Estimate sensitivity indices from system output, as a result of input design from SA_sample().
}
}
