% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{approx_df}
\alias{approx_df}
\title{Interpolate time-indexed data frame}
\usage{
approx_df(Y, tt, tt_est = NULL, ...)
}
\arguments{
\item{Y}{A data frame with all numeric columns}

\item{tt}{A time vector with length equal to \code{nrow(Y)}, indexing the rows in \code{Y}.}

\item{tt_est}{A time vector of points to interpolate in \code{Y}. If \code{NULL}, will attempt to interpolate all
points in \code{Y} (you may need to adjust the \code{rule} argument of \code{\link[stats:approxfun]{stats::approx()}} here). Note that points not
specified in \code{tt_est} will not be interpolated. \code{tt_est} does not need to be a subset of \code{tt}.}

\item{...}{Further arguments to pass to \code{\link[stats:approxfun]{stats::approx()}} other than \code{x}, \code{y} and \code{xout}.}
}
\value{
A list with:
\itemize{
\item \code{.$tt} the vector of time points, including time values of interpolated points
\item \code{.$Y}  the corresponding interpolated data frame
}

Both outputs are sorted by \code{tt}.
}
\description{
Given a numeric data frame \code{Y} with rows indexed by a time vector \code{tt}, interpolates at time values
specified by the vector \code{tt_est}. If \code{tt_est} is not in \code{tt}, will create new rows in the data frame
corresponding to these interpolated points.
}
\details{
This is a wrapper for \code{\link[stats:approxfun]{stats::approx()}}, with some differences. In the first place, \code{\link[stats:approxfun]{stats::approx()}} is
applied to each column of \code{Y}, using \code{tt} each time as the corresponding time vector indexing \code{Y}. Interpolated
values are generated at points specified in \code{tt_est} but these are appended to the existing data (whereas
\code{\link[stats:approxfun]{stats::approx()}} will only return the interpolated points and nothing else). Further arguments to
\code{\link[stats:approxfun]{stats::approx()}} can be passed using the \code{...} argument.
}
\examples{
# a time vector
tt <- 2011:2020

# two random vectors with some missing values
y1 <- runif(10)
y2 <- runif(10)
y1[2] <- y1[5] <- NA
y2[3] <- y2[5] <- NA
# make into df
Y <- data.frame(y1, y2)

# interpolate for time = 2012
Y_int <- approx_df(Y, tt, 2012)
Y_int$Y

# notice Y_int$y2 is unchanged since at 2012 it did not have NA value
stopifnot(identical(Y_int$Y$y2, y2))

# interpolate at value not in tt
approx_df(Y, tt, 2015.5)

}
