% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pistar_by_chain.R
\name{pistar_by_chain}
\alias{pistar_by_chain}
\title{Compute the Mean Conditional Probability of Correct Classification, by True Outcome Across all Subjects for each MCMC Chain}
\usage{
pistar_by_chain(n_chains, chains_list, Z, n, n_cat)
}
\arguments{
\item{n_chains}{An integer specifying the number of MCMC chains to compute over.}

\item{chains_list}{A numeric list containing the samples from \code{n_chains}
MCMC chains.}

\item{Z}{A numeric design matrix.}

\item{n}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{Z}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcome, \code{Y*} can take.}
}
\value{
\code{pistar_by_chain} returns a numeric matrix of the average
conditional probability \eqn{P(Y^* = j | Y = j, Z)} across all subjects for
each MCMC chain. Rows of the matrix correspond to MCMC chains, up to \code{n_chains}.
The first column contains the conditional probability \eqn{P(Y^* = 1 | Y = 1, Z)}.
The second column contains the conditional probability \eqn{P(Y^* = 2 | Y = 2, Z)}.
}
\description{
Compute the Mean Conditional Probability of Correct Classification, by True Outcome Across all Subjects for each MCMC Chain
}
