% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicmp-reg.R
\name{glm.cmp, ZICMP support}
\alias{glm.cmp, ZICMP support}
\alias{summary.zicmp}
\alias{print.zicmp}
\alias{logLik.zicmp}
\alias{AIC.zicmp}
\alias{BIC.zicmp}
\alias{coef.zicmp}
\alias{nu.zicmp}
\alias{sdev.zicmp}
\alias{vcov.zicmp}
\alias{leverage.zicmp}
\alias{deviance.zicmp}
\alias{residuals.zicmp}
\alias{predict.zicmp}
\alias{parametric.bootstrap.zicmp}
\title{Supporting Functions for ZICMP Regression}
\usage{
\method{summary}{zicmp}(object, ...)

\method{print}{zicmp}(x, ...)

\method{logLik}{zicmp}(object, ...)

\method{AIC}{zicmp}(object, ..., k = 2)

\method{BIC}{zicmp}(object, ...)

\method{coef}{zicmp}(object, ...)

\method{nu}{zicmp}(object, ...)

\method{sdev}{zicmp}(object, ...)

\method{vcov}{zicmp}(object, ...)

\method{leverage}{zicmp}(object, ...)

\method{deviance}{zicmp}(object, ...)

\method{residuals}{zicmp}(object, type = c("raw", "quantile"), ...)

\method{predict}{zicmp}(object, newdata = NULL, ...)

\method{parametric.bootstrap}{zicmp}(object, reps = 1000,
  report.period = reps + 1, ...)
}
\arguments{
\item{object}{object of type \code{zicmp}.}

\item{...}{other model parameters, such as data.}

\item{x}{object of type \code{zicmp}.}

\item{k}{Penalty per parameter to be used in AIC calculation.}

\item{type}{Type of residual to be computed.}

\item{newdata}{New covariates to be used for prediction.}

\item{reps}{Number of bootstrap repetitions.}

\item{report.period}{Report progress every \code{report.period} iterations.}
}
\description{
Supporting Functions for ZICMP Regression
}
