% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{detect.sid.points}
\alias{detect.sid.points}
\title{Find strat/end transcription points.}
\usage{
detect.sid.points(cd, sizeWindow, verbose = TRUE)
}
\arguments{
\item{cd}{A data table containing the coverage depth of an RNA-seq expression profile(s).}

\item{sizeWindow}{An annotation data table.}

\item{verbose}{}
}
\description{
Internal function to identify the boundaries of transcriptionally active regions using a sliding window algorithm.
The sliding window algorithm uses fixed windows with a length of 100 nt that slides across the coverage-depth data table
and finds segments of coverage depth highly and statistically correlated with a vector of 100 integers modeling 
a simple shape of sharp increases (or decreases) in transcription: x =???[0..0,1..1] (or x =???[1..1,0..0])).
}
\details{
With default values, segments having a positive correlation coefficient (exceeding 0.7) and a significant correlation test p-value (<10-7) are selected. 
are slected. The vector of the sliding window of 100 integers is a good trade-off between the accuracy of sharp increases/decreases 
in transcription and the computational costs of the procedure. P-value 10-7 allows reliable identification of sharp increases/decreases
in transcription.
}
\author{
Vittorio Fortino
detect.sid.points()
}
\keyword{internal}

