% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{sim_hs_stat}
\alias{sim_hs_stat}
\title{Hidalgo-Seo Statistic Simulation}
\usage{
sim_hs_stat(size, corr = TRUE, gen_func = rnorm, args = NULL,
  n = 500, parallel = FALSE, use_kernel_var = FALSE, kernel = "ba",
  bandwidth = "and")
}
\arguments{
\item{size}{Number of realizations to simulate}

\item{corr}{Whether long-run variance should be computed under the assumption
of correlated residuals}

\item{gen_func}{The function generating the random sample from which the
statistic is computed}

\item{args}{A list of arguments to be passed to \code{gen_func}}

\item{n}{The sample size for each realization}

\item{parallel}{Whether to use the \pkg{foreach} and \pkg{doParallel}
packages to parallelize simulation (which needs to be
initialized in the global namespace before use)}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel-based long-run
variance estimation (\code{FALSE} means this is not
employed); \emph{TODO: NOT CURRENTLY IMPLEMENTED}}

\item{kernel}{If character, the identifier of the kernel function as used in
the \pkg{cointReg} (see documentation for
\code{cointReg::getLongRunVar}); if function, the kernel
function to be used for long-run variance estimation (default
is the Bartlett kernel in \pkg{cointReg}); this parameter
has no effect if \code{use_kernel_var} is \code{FALSE};
\emph{TODO: NOT CURRENTLY IMPLEMENTED}}

\item{bandwidth}{If character, the identifier of how to compute the bandwidth
as defined in the \pkg{cointReg} package (see
documentation for \code{cointReg::getLongRunVar}); if
function, a function to use for computing the bandwidth; if
numeric, the bandwidth to use (the default behavior is to
use the \insertCite{andrews91b;textual}{CPAT} method, as
used in \pkg{cointReg}); this parameter has no effect if
\code{use_kernel_var} is \code{FALSE}; \emph{TODO: NOT
CURRENTLY IMPLEMENTED}}
}
\value{
A vector of simulated realizations of the Hidalgo-Seo statistic
}
\description{
Simulates multiple realizations of the Hidalgo-Seo statistic.
}
\details{
If \code{corr} is \code{TRUE}, then the residuals of the data-generating
process are assumed to be correlated and the test accounts for this in
long-run variance estimation; see the documentation for \code{\link{stat_hs}}
for more details. Otherwise, the sample variance is the estimate for the
long-run variance, as described in \insertCite{hidalgoseo13;textual}{CPAT}.
}
\examples{
CPAT:::sim_hs_stat(100)
CPAT:::sim_hs_stat(100, gen_func = CPAT:::rchangepoint, 
                   args = list(changepoint = 250, mean2 = 1))
}
\references{
\insertAllCited{}
}
