% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.penCSC.R
\name{predict.penCSC}
\alias{predict.penCSC}
\title{predict.penCSC}
\usage{
\method{predict}{penCSC}(object, newX, event = NULL, time, type = "lp", reference = "zero", ...)
}
\arguments{
\item{object}{An object of class `penCSC`.}

\item{newX}{A data frame containing the information of variables related to new records. Information of variables not included in the model creation will be ignored.}

\item{event}{A vector of event codes which we want predictions for. This must be the same as values in the status variable of the data that was used to create the models. If \code{NULL}, absolute risk will be calculated for all involved events. Default is \code{NULL} which returns values for all involved causes.}

\item{time}{A vector of time horizons which we want absolute risk predictions at. Only applicable when \code{type='absRisk'}.}

\item{type}{Type of the predictions. Valid values are: \code{'lp'} or \code{'link'} for linear predictors, \code{'risk'} or \code{'response'} for \code{exp(lp)} and finally \code{'absRisk'} for semi-parametric estimates of absolute risk.}

\item{reference}{Reference for centering predictions. Valid values are \code{'zero'} and \code{'sample'}. Default is \code{'zero'}. For more information on referencing see details in \code{?predict.coxph}.}

\item{...}{Additional arguments. Not used by \code{predict.penCSC}.}
}
\value{
A tibble containing the predictions based on the input arguments.
}
\description{
Flexible prediction method for the objects of class `penCSC` including the absolute risk prediction.
}
\examples{

library(riskRegression)

data(Melanoma)

vl <- list('1'=c('age','sex','ulcer','thick'),

          '2'=~age+sex+epicel+thick+ici)

al <- list('1'=0,'2'=.5)

ll <- list('1'=.01,'2'=.04)

penfit <- penCSC(time='time',status='status',vars.list=vl,

                data=Melanoma,alpha.list=al,lambda.list=ll)

predict(penfit,Melanoma[1:5,],type='lp')

predict(penfit,Melanoma[1:5,],type='response')

predict(penfit,Melanoma[1:5,],type='absRisk',event=1:2,time=1825*(1:2))

}
\references{
Pfeiffer, R. M., & Gail, M. M. (2017). Absolute risk: Methods and applications in clinical management and public health.

Aalen, O.O. (1978) Nonparametric Inference for a Family of Counting Processes. The Annals of Statistics, 6, 701-726. \doi{10.1214/aos/1176344247}.

Wickham H, Averick M, Bryan J, Chang W, McGowan L, François R, et al. Welcome to the tidyverse. J Open Source Softw. 2019 Nov 21;4(43):1686.

Bache S, Wickham H (2022). magrittr: A Forward-Pipe Operator for R. \url{https://magrittr.tidyverse.org}, \url{https://github.com/tidyverse/magrittr}.

Friedman J, Hastie T, Tibshirani R (2010). "Regularization Paths for Generalized Linear Models via Coordinate Descent." Journal of Statistical Software, 33(1), 1-22. \doi{10.18637/jss.v033.i01}, \url{https://www.jstatsoft.org/v33/i01/}.
}
\author{
Shahin Roshani
}
