% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Calibration.R
\name{CST_Calibration}
\alias{CST_Calibration}
\title{Forecast Calibration based on the ensemble inflation}
\usage{
CST_Calibration(exp, obs)
}
\arguments{
\item{exp}{an object of class \code{s2dv_cube} as returned by \code{CST_Load} function, containing the seasonal forecast experiment data in the element named \code{$data}.}

\item{obs}{an object of class \code{s2dv_cube} as returned by \code{CST_Load} function, containing the observed data in the element named \code{$data}.}
}
\value{
an object of class \code{s2dv_cube} containing the calibrated forecasts in the element \code{$data} with the same dimensions of the experimental data.
}
\description{
This function applies a variance inflation technique described in Doblas-Reyes et al. (2005) in leave-one-out cross-validation. This bias adjustment method produces calibrated forecasts with equivalent mean and variance to that of the reference dataset, but at the same time preserve reliability.
}
\examples{
# Example
# Load data using CST_Load or use the sample data provided:
library(zeallot)
c(exp, obs) \%<-\% areave_data
exp_calibrated <- CST_Calibration(exp = exp, obs = obs)
str(exp_calibrated)
}
\author{
Verónica Torralba, \email{veronica.torralba@bsc.es}
}
\references{
Doblas-Reyes F.J, Hagedorn R, Palmer T.N. The rationale behind the success of multi-model ensembles in seasonal forecasting-II calibration and combination. Tellus A. 2005;57:234-252. doi:10.1111/j.1600-0870.2005.00104.x
}
\seealso{
\code{\link{CST_Load}}
}
\encoding{UTF-8}
