% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_AdamontAnalog.R
\name{CST_AdamontAnalog}
\alias{CST_AdamontAnalog}
\alias{AdamontAnalog}
\title{CST_AdamontAnalog finds analogous data in the reference dataset to experiment
data based on weather types}
\usage{
CST_AdamontAnalog(
  exp,
  obs,
  wt_exp,
  wt_obs,
  nanalogs,
  method = "pattcorr",
  thres = NULL,
  search_obsdims = c("member", "sdate", "ftime"),
  londim = "lon",
  latdim = "lat"
)

AdamontAnalog(
  exp,
  obs,
  wt_exp,
  wt_obs,
  nanalogs = 5,
  method = "pattcorr",
  thres = NULL,
  search_obsdims = c("member", "sdate", "ftime"),
  londim = "lon",
  latdim = "lat"
)
}
\arguments{
\item{exp}{\itemize{
\item\code{CST_AdamontAnalog}{experiment data an object of class \code{s2dv_cube}, can be output 
from quantile correction using CST_AdamontQQCorr}
\item\code{AdamontAnalog}{experiment data array with named dimension}}}

\item{obs}{\itemize{
\item\code{CST_AdamontAnalog}{reference data, also of class \code{s2dv_cube}.}
\item\code{AdamontAnalog}{reference data array with named dimension.}}
Note that lat/lon dimensions need to be the same as \code{exp}}

\item{wt_exp}{corresponding weather types (same dimensions as \code{exp$data} 
but lat/lon)}

\item{wt_obs}{corresponding weather types (same dimensions as \code{obs$data}
but lat/lon)}

\item{nanalogs}{integer defining the number of analog values to return
(default: 5)}

\item{method}{a character string indicating the method used for analog
definition
      Coded are 'pattcorr': pattern correlation
           'rain1' (for precip patterns): rain occurrence consistency
           'rain01' (for precip patterns): rain occurrence/non 
                       occurrence consistency}

\item{thres}{real number indicating the threshold to define rain 
occurrence/non occurrence in rain(0)1}

\item{search_obsdims}{list of dimensions in \code{obs} along which analogs are
searched for}

\item{londim}{name of longitude dimension}

\item{latdim}{name of latitude dimension}
}
\value{
analog_vals 
\itemize{
\item\code{CST_AdamontAnalog}{an object of class \code{s2dv_cube} containing nanalogs
analog values for each value of \code{exp} input data}
\item\code{AdamontAnalog}{an array containing nanalogs analog values}}
}
\description{
This function searches for analogs in a reference dataset for 
experiment data, based on corresponding weather types. The experiment data is
typically a hindcast, observations are typically provided by reanalysis data.
}
\examples{
\dontrun{
wt_exp <- sample(1:3, 15*6*3, replace=T)
dim(wt_exp) <- c(dataset=1, member=15, sdate=6, ftime=3)
wt_obs <- sample(1:3, 6*3, replace=T)
dim(wt_obs) <- c(dataset=1, member=1, sdate=6, ftime=3)
}
\dontrun{
wt_exp <- sample(1:3, 15*6*3, replace=T)
dim(wt_exp) <- c(dataset=1, member=15, sdate=6, ftime=3)
wt_obs <- sample(1:3, 6*3, replace=T)
dim(wt_obs) <- c(dataset=1, member=1, sdate=6, ftime=3)
  obs=lonlat_temp$obs$data, wt_exp=wt_exp, wt_obs=wt_obs, nanalogs=2)
}
}
\author{
Paola Marson, \email{paola.marson@meteo.fr} for PROSNOW version

Lauriane Batté, \email{lauriane.batte@meteo.fr} for CSTools adaptation
}
