% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csuv.r
\name{csuv}
\alias{csuv}
\title{Get the fitted results from Combined Selection and Uncertainty Visualiser (CSUV) method}
\usage{
csuv(
  X,
  Y,
  intercept,
  method.names = NULL,
  coef.est.method = lm.ols,
  B = 100,
  q = 0,
  fit.percent = 0.5,
  selection.criterion = "mse",
  num.core = 1,
  all.fits = NULL,
  log.level = NULL
)
}
\arguments{
\item{X}{covariates (n times p matrix, n: number of entries, p: number of covariates)}

\item{Y}{response (vector with n entries)}

\item{intercept}{TRUE to fit the data with an intercept, FALSE to fit the data without an intercept}

\item{method.names}{vector of method names to be used in CSUV. Choose among "lasso", "elastic", "relaxo", "mcp" and "scad". Default is to use all methods listed above}

\item{coef.est.method}{method to estimate the coefficients of covariates after variable selection. User can provide his/her function. Default is ordinary least square}

\item{B}{number of subsampling. Default is 100}

\item{q}{percentile of fitted models used per each subsampling in CSUV, according to the selection criterion on out-of-sample data in ascending order. Default is q = 0 (only the fitted model with the lowest MSE in a subsampling data is used)}

\item{fit.percent}{percentage of observations used in fitting in CSUV}

\item{selection.criterion}{= c("mse", "ebic"). Measure to select fitted models in subsampling dataset. "mse" is mean square error and "ebic" is extended BIC. Default is mse}

\item{num.core}{number of cores to use. Default is 1 (i.e. no parallel running)}

\item{all.fits}{(optional) all fitted models. If all.fits is provided, then CSUV will use the fitted models in all.fitted instead of fitting using subsampling data}

\item{log.level}{log level to set. Default is NULL, which means no change in log level. See the function CSUV::set.log.level for more details}
}
\value{
a list, which includes estimated coefficients (est.b), subsampling fitted models (mod.collection), number of times a method is selected (method.freq), relative frequency of each covariate (variable.freq), covariates ordered by relative frequency (variable.order).
}
\description{
Get the fitted results from Combined Selection and Uncertainty Visualiser (CSUV) method
}
\examples{
\donttest{
X = matrix(rnorm(1000), nrow = 100)
Y = rowSums(X[,1:3])+rnorm(100)
mod.0 = csuv(X, Y, intercept = FALSE, q = 0, method.names = NULL)
print(mod.0)
mod.5 = csuv(X, Y, intercept = FALSE, q = 5, all.fits = mod.0$all.fits)
print(mod.5)
}
}
