% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dissim.R
\name{dissim}
\alias{dissim}
\title{Normalized dissimilarity measure}
\usage{
dissim(proba,probb)
}
\arguments{
\item{proba}{Vector of observed relative frequencies}

\item{probb}{Vector of estimated (theoretical) probabilities}
}
\value{
Numeric value of the dissimilarity index, assessing the distance to a perfect fit.
}
\description{
Compute the normalized dissimilarity measure between observed
 relative frequencies and estimated (theoretical) probabilities of a discrete distribution.
}
\examples{
proba<-c(0.01,0.03,0.08,0.07,0.27,0.37,0.17)
probb<-c(0.04,0.04,0.05,0.10,0.21,0.32,0.24)
dissim(proba,probb)
}
\keyword{univar}

