% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/probcubshe3.R
\name{probcubshe3}
\alias{probcubshe3}
\title{probcubshe3}
\usage{
probcubshe3(m,lambda,eta,csi,shelter)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{lambda}{Mixing coefficient for the shifted Binomial component}

\item{eta}{Mixing coefficient for the mixture of the uncertainty component and the
shelter effect}

\item{csi}{Feeling parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\value{
The vector of the probability distribution of a CUB model with shelter effect.
}
\description{
Probability distribution of a CUB model with explicit shelter effect:
satisficing interpretation
}
\details{
The "satisficing interpretation" provides a parametrization for CUB models with explicit
shelter effect as a mixture of two components: a shifted Binomial distribution with feeling parameter
\eqn{\xi} (meditated choice), and a mixture of a degenerate distribution with unit mass at the shelter
category (\code{shelter}) and a discrete uniform distribution over \eqn{m} categories, with mixing
coefficient specified by \eqn{\eta} (lazy selection of a category).
}
\examples{
m<-8
pai1<-0.5
pai2<-0.3
csi<-0.4
shelter<-6
lambda<-pai1
eta<-1-pai2/(1-pai1)
pr3<-probcubshe3(m,lambda,eta,csi,shelter)
plot(1:m,pr3,type="h",main="CUB probability distribution with explicit
shelter effect",xlab="Ordinal categories")
points(1:m,pr3,pch=19)
}
\references{
Iannario M. (2012). Modelling \emph{shelter} choices in a class of mixture models for ordinal responses,
\emph{Statistical Methods and Applications}, \bold{21}, 1--22 \cr
}
\seealso{
\code{\link{probcubshe1}}, \code{\link{probcubshe2}}
}
\keyword{distribution}

