% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/exports.R
\docType{methods}
\name{*,Expression,Expression-method}
\alias{*,Expression,Expression-method}
\alias{*,Expression,ConstVal-method}
\alias{*,ConstVal,Expression-method}
\alias{mul_elemwise}
\alias{*}
\title{Elementwise Multiplication}
\usage{
\S4method{*}{Expression,Expression}(e1, e2)

\S4method{*}{Expression,ConstVal}(e1, e2)

\S4method{*}{ConstVal,Expression}(e1, e2)

mul_elemwise(lh_const, rh_exp)
}
\arguments{
\item{e1, e2}{The \linkS4class{Expression} objects or numeric constants to multiply elementwise.}

\item{lh_const}{A constant \linkS4class{Expression}, vector, or matrix representing the left-hand value.}

\item{rh_exp}{An \linkS4class{Expression}, vector, or matrix representing the right-hand value.}
}
\value{
An \linkS4class{Expression} representing the elementwise product of the inputs.
}
\description{
The elementwise product of two expressions. The first expression must be constant.
}
\examples{
A <- Variable(2,2)
c <- cbind(c(1,-1), c(2,-2))
expr <- mul_elemwise(c, A)
obj <- Minimize(norm_inf(expr))
prob <- Problem(obj, list(A == 5))
result <- solve(prob)
result$value
result$getValue(expr)
}
