% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{SymmetricUpperTri-class}
\alias{SymmetricUpperTri-class}
\alias{.SymmetricUpperTri}
\alias{SymmetricUpperTri}
\alias{as.character,SymmetricUpperTri-method}
\alias{get_data,SymmetricUpperTri-method}
\title{The SymmetricUpperTri class.}
\usage{
SymmetricUpperTri(n, name = NA_character_)

\S4method{as.character}{SymmetricUpperTri}(x)

\S4method{get_data}{SymmetricUpperTri}(object)
}
\arguments{
\item{n}{The number of rows/columns in the matrix.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{x, object}{A \linkS4class{SymmetricUpperTri} object.}
}
\description{
This class represents the upper triangular part of a symmetric variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_data}: Returns \code{list(n, name)}.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique identification number used internally.}

\item{\code{n}}{The number of rows/columns in the matrix.}

\item{\code{rows}}{The number of rows in the variable.}

\item{\code{cols}}{The number of columns in the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}

\item{\code{primal_value}}{(Internal) The primal value of the variable stored internally.}
}}

\examples{
x <- SymmetricUpperTri(3, name="s3")
name(x)
get_data(x)
}
