% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{MulElemwise-class}
\alias{MulElemwise-class}
\alias{.MulElemwise}
\alias{MulElemwise}
\alias{validate_args,MulElemwise-method}
\alias{to_numeric,MulElemwise-method}
\alias{size_from_args,MulElemwise-method}
\alias{sign_from_args,MulElemwise-method}
\alias{is_incr,MulElemwise-method}
\alias{is_decr,MulElemwise-method}
\alias{is_quadratic,MulElemwise-method}
\alias{graph_implementation,MulElemwise-method}
\title{The MulElemwise class.}
\usage{
MulElemwise(lh_const, rh_exp)

\S4method{validate_args}{MulElemwise}(object)

\S4method{to_numeric}{MulElemwise}(object, values)

\S4method{size_from_args}{MulElemwise}(object)

\S4method{sign_from_args}{MulElemwise}(object)

\S4method{is_incr}{MulElemwise}(object, idx)

\S4method{is_decr}{MulElemwise}(object, idx)

\S4method{is_quadratic}{MulElemwise}(object)

\S4method{graph_implementation}{MulElemwise}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{lh_const}{A constant \linkS4class{Expression} or numeric value.}

\item{rh_exp}{An \linkS4class{Expression}.}

\item{object}{A \linkS4class{MulElemwise} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise multiplication of two expressions. The first expression must be constant.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check the first argument is a constant.

\item \code{to_numeric}: Multiply the values elementwise.

\item \code{size_from_args}: The size of the atom.

\item \code{sign_from_args}: The sign of the atom.

\item \code{is_incr}: Is the left-hand constant positive?

\item \code{is_decr}: Is the left-hand constant negative?

\item \code{is_quadratic}: Is the right-hand expression quadratic?

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{lh_const}}{A constant \linkS4class{Expression} or numeric value.}

\item{\code{rh_exp}}{An \linkS4class{Expression}.}
}}

