% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{ExpCone-class}
\alias{ExpCone-class}
\alias{.ExpCone}
\alias{ExpCone}
\alias{as.character,ExpCone-method}
\alias{residual,ExpCone-method}
\alias{size,ExpCone-method}
\alias{num_cones,ExpCone-method}
\alias{cone_sizes,ExpCone-method}
\alias{is_dcp,ExpCone-method}
\alias{is_dgp,ExpCone-method}
\alias{canonicalize,ExpCone-method}
\title{The ExpCone class.}
\usage{
ExpCone(x, y, z, id = NA_integer_)

\S4method{as.character}{ExpCone}(x)

\S4method{residual}{ExpCone}(object)

\S4method{size}{ExpCone}(object)

\S4method{num_cones}{ExpCone}(object)

\S4method{cone_sizes}{ExpCone}(object)

\S4method{is_dcp}{ExpCone}(object)

\S4method{is_dgp}{ExpCone}(object)

\S4method{canonicalize}{ExpCone}(object)
}
\arguments{
\item{x}{The variable \eqn{x} in the exponential cone.}

\item{y}{The variable \eqn{y} in the exponential cone.}

\item{z}{The variable \eqn{z} in the exponential cone.}

\item{id}{(Optional) A numeric value representing the constraint ID.}

\item{object}{A \linkS4class{ExpCone} object.}
}
\description{
This class represents a reformulated exponential cone constraint operating elementwise on \eqn{a, b, c}.
}
\details{
Original cone:
\deqn{
K = \{(x,y,z) | y > 0, ye^{x/y} \leq z\} \cup \{(x,y,z) | x \leq 0, y = 0, z \geq 0\}
}
Reformulated cone:
\deqn{
K = \{(x,y,z) | y, z > 0, y\log(y) + x \leq y\log(z)\} \cup \{(x,y,z) | x \leq 0, y = 0, z \geq 0\}
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{residual}: The size of the \code{x} argument.

\item \code{size}: The number of entries in the combined cones.

\item \code{num_cones}: The number of elementwise cones.

\item \code{cone_sizes}: The dimensions of the exponential cones.

\item \code{is_dcp}: An exponential constraint is DCP if each argument is affine.

\item \code{is_dgp}: Is the constraint DGP?

\item \code{canonicalize}: Canonicalizes by converting expressions to LinOps.
}}

\section{Slots}{

\describe{
\item{\code{x}}{The variable \eqn{x} in the exponential cone.}

\item{\code{y}}{The variable \eqn{y} in the exponential cone.}

\item{\code{z}}{The variable \eqn{z} in the exponential cone.}
}}

