% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\docType{class}
\name{Problem-class}
\alias{Problem-class}
\alias{.Problem}
\alias{Problem}
\alias{objective,Problem-method}
\alias{objective<-,Problem-method}
\alias{constraints,Problem-method}
\alias{constraints<-,Problem-method}
\alias{value,Problem-method}
\alias{value<-,Problem-method}
\alias{status,Problem-method}
\alias{is_dcp,Problem-method}
\alias{is_dgp,Problem-method}
\alias{is_qp,Problem-method}
\alias{canonicalize,Problem-method}
\alias{is_mixed_integer,Problem-method}
\alias{variables,Problem-method}
\alias{parameters,Problem-method}
\alias{constants,Problem-method}
\alias{atoms,Problem-method}
\alias{size_metrics,Problem-method}
\alias{solver_stats,Problem-method}
\alias{solver_stats<-,Problem-method}
\alias{get_problem_data,Problem,character,logical-method}
\alias{get_problem_data,Problem,character,missing-method}
\alias{unpack_results,Problem-method}
\title{The Problem class.}
\usage{
Problem(objective, constraints = list())

\S4method{objective}{Problem}(object)

\S4method{objective}{Problem}(object) <- value

\S4method{constraints}{Problem}(object)

\S4method{constraints}{Problem}(object) <- value

\S4method{value}{Problem}(object)

\S4method{value}{Problem}(object) <- value

\S4method{status}{Problem}(object)

\S4method{is_dcp}{Problem}(object)

\S4method{is_dgp}{Problem}(object)

\S4method{is_qp}{Problem}(object)

\S4method{canonicalize}{Problem}(object)

\S4method{is_mixed_integer}{Problem}(object)

\S4method{variables}{Problem}(object)

\S4method{parameters}{Problem}(object)

\S4method{constants}{Problem}(object)

\S4method{atoms}{Problem}(object)

\S4method{size_metrics}{Problem}(object)

\S4method{solver_stats}{Problem}(object)

\S4method{solver_stats}{Problem}(object) <- value

\S4method{get_problem_data}{Problem,character,logical}(object, solver, gp)

\S4method{get_problem_data}{Problem,character,missing}(object, solver, gp)

\S4method{unpack_results}{Problem}(object, solution, chain, inverse_data)
}
\arguments{
\item{objective}{A \linkS4class{Minimize} or \linkS4class{Maximize} object representing the optimization objective.}

\item{constraints}{(Optional) A list of \linkS4class{Constraint} objects representing constraints on the optimization variables.}

\item{object}{A \linkS4class{Problem} class.}

\item{value}{A \linkS4class{Minimize} or \linkS4class{Maximize} object (objective), list of \linkS4class{Constraint} objects (constraints), or numeric scalar (value).}

\item{solver}{A string indicating the solver that the problem data is for. Call \code{installed_solvers()} to see all available.}

\item{gp}{Is the problem a geometric problem?}

\item{solution}{A \linkS4class{Solution} object.}

\item{chain}{The corresponding solving \linkS4class{Chain}.}

\item{inverse_data}{A \linkS4class{InverseData} object or list containing data necessary for the inversion.}
}
\description{
This class represents a convex optimization problem.
}
\section{Methods (by generic)}{
\itemize{
\item \code{objective}: The objective of the problem.

\item \code{objective<-}: Set the value of the problem objective.

\item \code{constraints}: A list of the constraints of the problem.

\item \code{constraints<-}: Set the value of the problem constraints.

\item \code{value}: The value from the last time the problem was solved (or NA if not solved).

\item \code{value<-}: Set the value of the optimal objective.

\item \code{status}: The status from the last time the problem was solved.

\item \code{is_dcp}: A logical value indicating whether the problem statisfies DCP rules.

\item \code{is_dgp}: A logical value indicating whether the problem statisfies DGP rules.

\item \code{is_qp}: A logical value indicating whether the problem is a quadratic program.

\item \code{canonicalize}: The graph implementation of the problem.

\item \code{is_mixed_integer}: logical value indicating whether the problem is a mixed integer program.

\item \code{variables}: List of \linkS4class{Variable} objects in the problem.

\item \code{parameters}: List of \linkS4class{Parameter} objects in the problem.

\item \code{constants}: List of \linkS4class{Constant} objects in the problem.

\item \code{atoms}: List of \linkS4class{Atom} objects in the problem.

\item \code{size_metrics}: Information about the size of the problem.

\item \code{solver_stats}: Additional information returned by the solver.

\item \code{solver_stats<-}: Set the additional information returned by the solver in the problem.

\item \code{get_problem_data}: Get the problem data passed to the specified solver.

\item \code{get_problem_data}: Get the problem data passed to the specified solver.

\item \code{unpack_results}: Parses the output from a solver and updates the problem state, including the status,
objective value, and values of the primal and dual variables.
Assumes the results are from the given solver.
}}

\section{Slots}{

\describe{
\item{\code{objective}}{A \linkS4class{Minimize} or \linkS4class{Maximize} object representing the optimization objective.}

\item{\code{constraints}}{(Optional) A list of constraints on the optimization variables.}

\item{\code{value}}{(Internal) Used internally to hold the value of the optimization objective at the solution.}

\item{\code{status}}{(Internal) Used internally to hold the status of the problem solution.}

\item{\code{.cached_data}}{(Internal) Used internally to hold cached matrix data.}

\item{\code{.separable_problems}}{(Internal) Used internally to hold separable problem data.}

\item{\code{.size_metrics}}{(Internal) Used internally to hold size metrics.}

\item{\code{.solver_stats}}{(Internal) Used internally to hold solver statistics.}
}}

\examples{
x <- Variable(2)
p <- Problem(Minimize(p_norm(x, 2)), list(x >= 0))
is_dcp(p)
x <- Variable(2)
A <- matrix(c(1,-1,-1, 1), nrow = 2)
p <- Problem(Minimize(quad_form(x, A)), list(x >= 0))
is_qp(p)
}
