% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RD.R
\name{Carlson_RD}
\alias{Carlson_RD}
\title{Carlson elliptic integral RD}
\usage{
Carlson_RD(x, y, z, minerror = 2 * .Machine$double.eps)
}
\arguments{
\item{x, y, z}{real or complex numbers; at most one can be 0}

\item{minerror}{bound on the relative error}
}
\value{
A complex number, the value of the Carlson elliptic integral
\ifelse{html}{\out{R<sub>D</sub>(x,y,z)}}{\eqn{R_D(x,y,z)}{RD(x,y,z)}}.
}
\description{
Evaluate the Carlson elliptic integral RD.
}
\note{
The function returns a value when \code{x}, \code{y} or \code{z}
are negative real numbers, but this value is not the one of the
Carlson integral.
}
\examples{
Carlson_RD(5, 2, 3)
gsl::ellint_RD(5, 2, 3)
}
