% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{proximityMatrix}
\alias{proximityMatrix}
\title{Get proximity matrix of an ranger object}
\usage{
proximityMatrix(x, y = NULL, rfObject)
}
\arguments{
\item{x}{a new dataset}

\item{y}{a second new dataset (Default: NULL)}

\item{rfObject}{\code{ranger} object}
}
\value{
a \code{dist} or a matrix object with pairwise proximity of 
observations in x vs y (if not null)
}
\description{
Get proximity matrix of an ranger object
}
\examples{
require(ranger)
rf <- ranger(Species ~ ., data = iris, num.trees = 5, write.forest = TRUE)
d <- proximityMatrix(x = iris[, -5], rfObject = rf)

set.seed(1234L)
learn <- sample(1:150, 100)
test <- (1:150)[-learn]
rf <- ranger(Species ~ ., data = iris[learn, ], num.trees = 500, write.forest = TRUE)
d <- proximityMatrix(x = iris[learn, -5], y = iris[test, -5], rfObject = rf)

}
