.onAttach <-
function (lib, pkg) {
    pkg.info <- drop(read.dcf(file=system.file("DESCRIPTION", package="CatDyn"),
                              fields=c("Title","Version","Date")))

   packageStartupMessage(paste("--------------------------------------------------------------\n",
			       pkg.info["Title"]),"\n",
    paste(" CatDyn version ", pkg.info["Version"],
              " (built on ", pkg.info["Date"], ") is now loaded\n", sep=""),
			 "--------------------------------------------------------------\n"
    )
}
.psi.nb2 <-
function(psi,predcat1,obscat1) {sum(2*psi*log((psi+predcat1)/(psi+obscat1)) +
                                                     psi/(psi+obscat1) -
                                                     obscat1*(2*psi+obscat1)/(6*psi*(psi+obscat1)^2)) - psi}
.CatDynLik <-
function(obscat1,predcat1,distr,npar)
  {
                  Likel        <- vector("list",4);
                  names(Likel) <- c("Dispersion","Deviance","Likelihood","DevianceResidual");
                  sealen       <- length(obscat1);
                  if(distr=='poisson')
                    {
                     psi1        <- 1;
                     dev1        <- ifelse(obscat1==0 | predcat1==0,0,2*(obscat1*log(obscat1)-obscat1*log(predcat1)-(obscat1-predcat1)));
                     likcontr1   <- ifelse(predcat1==0,0,obscat1*log(predcat1) - predcat1 - lfactorial(obscat1));
                     res1        <- sign(obscat1-predcat1)*sqrt(dev1);
                    }
                  else if(distr=='negbin')
                    {
                     psi1        <- uniroot(f=.psi.nb2, interval=c(0.1,10), extendInt="upX", predcat1, obscat1)$root;
                     dev1        <- ifelse(obscat1==0,2*psi1*log(1+predcat1/psi1),
                                                      2*(obscat1*log(obscat1/predcat1)-(obscat1+psi1)*log((1+obscat1/psi1)/(1+predcat1/psi1))));
                     likcontr1   <- ifelse(predcat1==0,0,
                                           obscat1*log(1/psi1) +
                                           obscat1*log(predcat1) -
                                           (obscat1 + psi1)*log(1 + predcat1/psi1) +
                                           lgamma(obscat1 + psi1) -
                                           lgamma(obscat1 + 1) -
                                           lgamma(psi1));
                     res1        <- sign(obscat1-predcat1)*sqrt(dev1);
                    }
                  else if(distr=='normal')
                    {
                     psi1        <- sum((obscat1-predcat1)^2)/sealen;
                     dev1        <- ((obscat1-predcat1)^2)/sealen;
                     likcontr1   <- -(sealen/2)*log(2*pi*psi1)-(1/(2*psi1))*(obscat1-predcat1)^2;
                     res1        <- sign(obscat1-predcat1)*sqrt(dev1);
                    }
                  else if(distr=='apnormal')
                    {
                     psi1        <- NA;
                     res1        <- obscat1-predcat1;
                     likcontr1   <- res1^2;
                     dev1        <- res1;
                    }
                  else if(distr=='lognormal')
                    {
                     psi1        <- sum(ifelse(obscat1==0 | predcat1==0,0,(log(obscat1)-log(predcat1))^2))/sealen;
                     dev1        <- ifelse(obscat1==0 | predcat1==0,0,(log(obscat1)-log(predcat1))^2)/sealen;
                     likcontr1   <- ifelse(obscat1==0 | predcat1==0,0,-(sealen/2)*log(2*obscat1^2*pi*psi1)-(1/(2*psi1))*(log(obscat1)-log(predcat1))^2);
                     res1        <- sign(obscat1-predcat1)*sqrt(dev1);
                    }
                  else if(distr=='aplnormal')
                    {
                     psi1        <- NA;
                     res1        <- ifelse(obscat1==0 | predcat1==0,0,log(obscat1)-log(predcat1));
                     likcontr1   <- res1^2;
                     dev1        <- res1;
                    }
                  else if(distr=='gamma')
                    {
                     x <- vector("numeric",sealen)
                     for(i in 1:sealen)
                       {
                        x[i] <- ifelse(predcat1[i] == 0,0,(obscat1[i]-predcat1[i])^2/predcat1[i])
                       }
                     psi1        <- sum(x)/(sealen-(npar+1));
                     rm(x);
                     dev1        <- ifelse(obscat1==0 | predcat1==0,0,-(2/psi1)*(log(obscat1/predcat1)-(obscat1-predcat1)/predcat1));
                     likcontr1   <- ifelse(obscat1==0 | predcat1==0,0,(1/psi1)*(log(obscat1)-log(psi1*predcat1))-log(obscat1)-sealen*lgamma(1/psi1)-obscat1/(psi1*predcat1));
                     res1        <- sign(obscat1-predcat1)*sqrt(dev1);
                    }
                  Likel[[1]] <- psi1
                  Likel[[2]] <- dev1
                  Likel[[3]] <- likcontr1
                  Likel[[4]] <- res1
                  return(Likel);
  }
.CatDynExp1F.Res <-
function(properties,nstep,obsmbm1,ppp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
  {
                  if(properties$Units[2] == "ind")
                    {
                     biom <- NA
                    }
                  else
                    {
                     biom <- if(properties$Units[4] == "bill" && properties$Units[3] == "g")
                               {
                                obsmbm1*1e-6*nstep*1e9;
                               }
                             else if(properties$Units[4] == "bill" && properties$Units[3] == "kg")
                               {
                                obsmbm1*1e-3*nstep*1e9;
                               }
                             else if(properties$Units[4] == "mill" && properties$Units[3] == "g")
                               {
                                obsmbm1*1e-6*nstep*1e6;
                               }
                             else if(properties$Units[4] == "mill" && properties$Units[3] == "kg")
                               {
                               obsmbm1*1e-3*nstep*1e6;
                               }
                             else if(properties$Units[4] == "thou" && properties$Units[3] == "g")
                               {
                               obsmbm1*1e-6*nstep*1e3;
                               }
                             else if(properties$Units[4] == "thou" && properties$Units[3] == "kg")
                               {
                               obsmbm1*1e-3*nstep*1e3;
                               }
                             else if(properties$Units[4] == "hund" && properties$Units[3] == "g")
                               {
                               obsmbm1*1e-6*nstep*1e2;
                               }
                             else
                               {
                               obsmbm1*1e-3*nstep*1e2;
                               }
                    }
                  catdynexp                         <- vector("list",2);
                  names(catdynexp)                  <- c("Properties","Model");
                  catdynexp$Properties              <- properties;
                  catdynexp$Model                   <- vector("list",5);
                  names(catdynexp$Model)            <- c("Type","Dates","Distribution","Parameters","Results");
                  catdynexp$Model$Type              <- ppp;
                  catdynexp$Model$Dates             <- dates;
                  catdynexp$Model$Distribution      <- distr;
                  catdynexp$Model$Parameters        <- c(exp(par),Likel[[1]],dates);
                  if(ppp==0)
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k","alpha","beta","psi","ts.start","ts.end")
                    }
                  else if(ppp>0)
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0",paste("P",1:ppp,sep=""),"k","alpha","beta","psi","ts.start",paste("ts.P",1:ppp,sep=""),"ts.end")
                    }                                                   
                  else
                    {
                     ppp                               <- abs(ppp);
                     names(catdynexp$Model$Parameters) <- c("M","N0",paste("P",1:ppp,sep=""),"k","alpha","beta","psi","ts.start",paste(c("ts.P","ts.N"),sort(rep(1:ppp,2)),sep=""),"ts.end")
                    }                                                   
                  catdynexp$Model$Results           <- data.frame(period=ts.start:ts.end,
                                                                  obseff1=obseff1,
                                                                  obscat1=obscat1,
                                                                  modcat=predcat1,
                                                                  deviance=Likel[[2]],
                                                                  likcontr=Likel[[3]],
                                                                  devresid=Likel[[4]],
                                                                  npred=nstep,
                                                                  biompred=biom);
                  names(catdynexp$Model$Results)    <- c(paste("Period (",properties$Units[1],")",sep=""),
                                                         paste("Effort ",properties$Fleets[1,1]," Fleet (",properties$Fleets[1,2],")",sep=""),
                                                         paste("Obs. Catch ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                         paste("Pred. Catch ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                         paste("Deviance ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                         paste("Likelihood ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                         paste("Deviance Residuals ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                         paste("Pred. Abundance (",properties$Units[4],")",sep=""),
                                                         "Pred. Biomass (tonnes)")
                  return(catdynexp);
  }
.CatDynExp2F.Res <-
function(properties,nstep,obsmbm1,obsmbm2,ppp,dates,distr,par,Likel1,Likel2,ts.start,ts.end,obseff1,obscat1,predcat1,obseff2,obscat2,predcat2)
  {
                  if(properties$Units[2] == "ind")
                    {
                     biom <- NA
                    }
                  else
                    {
                     biom <- if(properties$Units[4] == "bill" && properties$Units[3] == "g")
                               {
                                (obsmbm1+obsmbm2)*0.5*1e-6*nstep*1e9;
                               }
                             else if(properties$Units[4] == "bill" && properties$Units[3] == "kg")
                               {
                                (obsmbm1+obsmbm2)*0.5*1e-3*nstep*1e9;
                               }
                             else if(properties$Units[4] == "mill" && properties$Units[3] == "g")
                               {
                                (obsmbm1+obsmbm2)*0.5*1e-6*nstep*1e6;
                               }
                             else if(properties$Units[4] == "mill" && properties$Units[3] == "kg")
                               {
                               (obsmbm1+obsmbm2)*0.5*1e-3*nstep*1e6;
                               }
                             else if(properties$Units[4] == "thou" && properties$Units[3] == "g")
                               {
                               (obsmbm1+obsmbm2)*0.5*1e-6*nstep*1e3;
                               }
                             else if(properties$Units[4] == "thou" && properties$Units[3] == "kg")
                               {
                               (obsmbm1+obsmbm2)*0.5*1e-3*nstep*1e3;
                               }
                             else if(properties$Units[4] == "hund" && properties$Units[3] == "g")
                               {
                               (obsmbm1+obsmbm2)*0.5*1e-6*nstep*1e2;
                               }
                             else
                               {
                               (obsmbm1+obsmbm2)*0.5*1e-3*nstep*1e2;
                               }
                    }
                  catdynexp                         <- vector("list",2);
                  names(catdynexp)                  <- c("Properties","Model");
                  catdynexp$Properties              <- properties;
                  catdynexp$Model                   <- vector("list",5);
                  names(catdynexp$Model)            <- c("Type","Dates","Distribution","Parameters","Results");
                  catdynexp$Model$Type              <- ppp;
                  catdynexp$Model$Dates             <- dates;
                  catdynexp$Model$Distribution      <- distr;
                  catdynexp$Model$Parameters        <- c(exp(par[c(1:((ppp[1]+5)))]),Likel1[[1]],exp(par[c((ppp[1]+6):length(par))]),Likel2[[1]],round(dates));
                  if(ppp == c(0,0))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","k2","alpha2","beta2","psi2","ts.start","ts.end")
                    }
                  else if(ppp == c(0,1))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","P1F2","k2","alpha2","beta2","psi2","ts.start","ts.P1F2","ts.end")
                    }
                  else if(ppp == c(0,2))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","P1F2","P2F2","k2","alpha2","beta2","psi2","ts.start","ts.P1F2","ts.P2F2","ts.end")
                    }
                  else if(ppp == c(0,3))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","P1F2","P2F2","P3F2","k2","alpha2","beta2","psi2","ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.end")
                    }
                  else if(ppp == c(0,4))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","P1F2","P2F2","P3F2","P4F2","k2","alpha2","beta2","psi2","ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.end")
                    }
                  else if(ppp == c(0,5))
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0","k1","alpha1","beta1","psi1","P1F2","P2F2","P3F2","P4F2","P5F2","k2","alpha2","beta2","psi2","ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.end")
                    }
                  else
                    {
                     names(catdynexp$Model$Parameters) <- c("M","N0",paste("P",1:ppp[1],"F1",sep=""),"k1","alpha1","beta1","psi1",paste("P",1:ppp[2],"F2",sep=""),"k2","alpha2","beta2","psi2","ts.start",paste("ts.P",1:ppp[1],"F1",sep=""),paste("ts.P",1:ppp[2],"F1",sep=""),"ts.end")
                    }
                  catdynexp$Model$Results           <- data.frame(period=ts.start:ts.end,
                                                                  obseff1=obseff1,
                                                                  obscat1=obscat1,
                                                                  modcat1=predcat1,
                                                                  deviance1=Likel1[[2]],
                                                                  likcontr1=Likel1[[3]],
                                                                  devresid1=Likel1[[4]],
                                                                  obseff2=obseff2,
                                                                  obscat2=obscat2,
                                                                  modcat2=predcat2,
                                                                  deviance2=Likel2[[2]],
                                                                  likcontr2=Likel2[[3]],
                                                                  devresid2=Likel2[[4]],
                                                                  npred=nstep,
                                                                  biompred=biom);
                  names(catdynexp$Model$Results) <- c(paste("Period (",properties$Units[1],")",sep=""),
                                                      paste("Effort ",properties$Fleets[1,1]," Fleet (",properties$Fleets[1,2],")",sep=""),
                                                      paste("Obs. Catch ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Pred. Catch ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Deviance ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Likelihood ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Deviance Residuals ",properties$Fleets[1,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Effort ",properties$Fleets[2,1]," Fleet (",properties$Fleets[2,2],")",sep=""),
                                                      paste("Obs. Catch ",properties$Fleets[2,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Pred. Catch ",properties$Fleets[2,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Deviance ",properties$Fleets[2,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Likelihood ",properties$Fleets[2,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Deviance Residuals ",properties$Fleets[2,1]," Fleet (",properties$Units[4],")",sep=""),
                                                      paste("Pred. Abundance (",properties$Units[4],")",sep=""),
                                                      "Pred. Biomass (tonnes)")
                  return(catdynexp);
  }
.CDMN0P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=0)
  {
                  ts.start  <- head(dates,1);
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logscale  <- par[3];
                  logalpha  <- par[4];
                  logbeta   <- par[5];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                    {
                    mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                    nstep[i] <- exp(logN0)*exp(-exp(logM)*i) - mccum[i]*exp(-exp(logM)/2);
                    }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN1P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=1)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start+1), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logscale  <- par[4];
                  logalpha  <- par[5];
                  logbeta   <- par[6];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                    {
                    mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                    nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start+1))) -
                                mccum[i]*exp(-exp(logM)/2);
                    }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN2P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=2)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logscale  <- par[5];
                  logalpha  <- par[6];
                  logbeta   <- par[7];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                    {
                    mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                    nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) -
                                mccum[i]*exp(-exp(logM)/2);
                    }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN3P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=3)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                   ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logscale  <- par[6];
                  logalpha  <- par[7];
                  logbeta   <- par[8];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen){
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN4P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=4)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logscale  <- par[7];
                  logalpha  <- par[8];
                  logbeta   <- par[9];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN5P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=5)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logscale  <- par[8];
                  logalpha  <- par[9];
                  logbeta   <- par[10];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN6P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=6)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logscale  <- par[9];
                  logalpha  <- par[10];
                  logbeta   <- par[11];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN7P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=7)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logscale  <- par[10];
                  logalpha  <- par[11];
                  logbeta   <- par[12];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN8P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=8)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logscale  <- par[11];
                  logalpha  <- par[12];
                  logbeta   <- par[13];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN9P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=9)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logscale  <- par[12];
                  logalpha  <- par[13];
                  logbeta   <- par[14];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN10P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=10)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logscale  <- par[13];
                  logalpha  <- par[14];
                  logbeta   <- par[15];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN11P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=11)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logscale  <- par[14];
                  logalpha  <- par[15];
                  logbeta   <- par[16];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN12P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=12)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logscale  <- par[15];
                  logalpha  <- par[16];
                  logbeta   <- par[17];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN13P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=13)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logscale  <- par[16];
                  logalpha  <- par[17];
                  logbeta   <- par[18];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN14P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=14)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logscale  <- par[17];
                  logalpha  <- par[18];
                  logbeta   <- par[19];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN15P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=15)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logscale  <- par[18];
                  logalpha  <- par[19];
                  logbeta   <- par[20];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN16P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=16)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logscale  <- par[19];
                  logalpha  <- par[20];
                  logbeta   <- par[21];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN17P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=17)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logscale  <- par[20];
                  logalpha  <- par[21];
                  logbeta   <- par[22];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN18P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=18)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logscale  <- par[21];
                  logalpha  <- par[22];
                  logbeta   <- par[23];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN19P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=19)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logscale  <- par[22];
                  logalpha  <- par[23];
                  logbeta   <- par[24];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN20P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=20)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logscale  <- par[23];
                  logalpha  <- par[24];
                  logbeta   <- par[25];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1   <- obseff1^(exp(logalpha));
                  effn1     <- nstep^(exp(logbeta));
                  predcat1  <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel     <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN21P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=21)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logscale  <- par[24];
                  logalpha  <- par[25];
                  logbeta   <- par[26];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN22P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=22)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logscale  <- par[25];
                  logalpha  <- par[26];
                  logbeta   <- par[27];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN23P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=23)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logscale  <- par[26];
                  logalpha  <- par[27];
                  logbeta   <- par[28];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN24P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=24)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logscale  <- par[27];
                  logalpha  <- par[28];
                  logbeta   <- par[29];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN25P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=25)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logscale  <- par[28];
                  logalpha  <- par[29];
                  logbeta   <- par[30];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN26P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=26)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logscale  <- par[29];
                  logalpha  <- par[30];
                  logbeta   <- par[31];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN27P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=27)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logscale  <- par[30];
                  logalpha  <- par[31];
                  logbeta   <- par[32];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN28P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=28)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logscale  <- par[31];
                  logalpha  <- par[32];
                  logbeta   <- par[33];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN29P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=29)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logscale  <- par[32];
                  logalpha  <- par[33];
                  logbeta   <- par[34];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN30P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=30)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logscale  <- par[33];
                  logalpha  <- par[34];
                  logbeta   <- par[35];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN31P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=31)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logscale  <- par[34];
                  logalpha  <- par[35];
                  logbeta   <- par[36];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN32P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=32)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logscale  <- par[35];
                  logalpha  <- par[36];
                  logbeta   <- par[37];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN33P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=33)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logscale  <- par[36];
                  logalpha  <- par[37];
                  logbeta   <- par[38];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN34P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=34)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logscale  <- par[37];
                  logalpha  <- par[38];
                  logbeta   <- par[39];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN35P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=35)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logscale  <- par[38];
                  logalpha  <- par[39];
                  logbeta   <- par[40];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN36P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=36)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logscale  <- par[39];
                  logalpha  <- par[40];
                  logbeta   <- par[41];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN37P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=37)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logscale  <- par[40];
                  logalpha  <- par[41];
                  logbeta   <- par[42];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN38P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=38)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logscale  <- par[41];
                  logalpha  <- par[42];
                  logbeta   <- par[43];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN39P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=39)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logscale  <- par[42];
                  logalpha  <- par[43];
                  logbeta   <- par[44];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN40P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=40)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logscale  <- par[43];
                  logalpha  <- par[44];
                  logbeta   <- par[45];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN41P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=41)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logscale  <- par[44];
                  logalpha  <- par[45];
                  logbeta   <- par[46];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN42P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=42)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logscale  <- par[45];
                  logalpha  <- par[46];
                  logbeta   <- par[47];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN43P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=43)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logscale  <- par[46];
                  logalpha  <- par[47];
                  logbeta   <- par[48];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN44P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=44)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logscale  <- par[47];
                  logalpha  <- par[48];
                  logbeta   <- par[49];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN45P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=45)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logscale  <- par[48];
                  logalpha  <- par[49];
                  logbeta   <- par[50];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN46P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=46)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logscale  <- par[49];
                  logalpha  <- par[50];
                  logbeta   <- par[51];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN47P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=47)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logscale  <- par[50];
                  logalpha  <- par[51];
                  logbeta   <- par[52];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN48P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=48)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logscale  <- par[51];
                  logalpha  <- par[52];
                  logbeta   <- par[53];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN49P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=49)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logscale  <- par[52];
                  logalpha  <- par[53];
                  logbeta   <- par[54];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN50P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=50)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logscale  <- par[53];
                  logalpha  <- par[54];
                  logbeta   <- par[55];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN51P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=51)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logscale  <- par[54];
                  logalpha  <- par[55];
                  logbeta   <- par[56];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN52P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=52)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logscale  <- par[55];
                  logalpha  <- par[56];
                  logbeta   <- par[57];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN53P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=53)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logscale  <- par[56];
                  logalpha  <- par[57];
                  logbeta   <- par[58];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN54P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=54)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logscale  <- par[57];
                  logalpha  <- par[58];
                  logbeta   <- par[59];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN55P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=55)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logscale  <- par[58];
                  logalpha  <- par[59];
                  logbeta   <- par[60];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN56P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=56)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logscale  <- par[59];
                  logalpha  <- par[60];
                  logbeta   <- par[61];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN57P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=57)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logscale  <- par[60];
                  logalpha  <- par[61];
                  logbeta   <- par[62];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN58P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=58)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logscale  <- par[61];
                  logalpha  <- par[62];
                  logbeta   <- par[63];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN59P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=59)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logscale  <- par[62];
                  logalpha  <- par[63];
                  logbeta   <- par[64];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN60P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=60)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logscale  <- par[63];
                  logalpha  <- par[64];
                  logbeta   <- par[65];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN61P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=61)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logscale  <- par[64];
                  logalpha  <- par[65];
                  logbeta   <- par[66];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN62P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=62)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logscale  <- par[65];
                  logalpha  <- par[66];
                  logbeta   <- par[67];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN63P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=63)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logscale  <- par[66];
                  logalpha  <- par[67];
                  logbeta   <- par[68];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN64P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=64)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logscale  <- par[67];
                  logalpha  <- par[68];
                  logbeta   <- par[69];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN65P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=65)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logscale  <- par[68];
                  logalpha  <- par[69];
                  logbeta   <- par[70];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN66P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=66)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logscale  <- par[69];
                  logalpha  <- par[70];
                  logbeta   <- par[71];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN67P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=67)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logscale  <- par[70];
                  logalpha  <- par[71];
                  logbeta   <- par[72];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN68P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=68)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logscale  <- par[71];
                  logalpha  <- par[72];
                  logbeta   <- par[73];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN69P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=69)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logscale  <- par[72];
                  logalpha  <- par[73];
                  logbeta   <- par[74];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN70P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=70)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logscale  <- par[73];
                  logalpha  <- par[74];
                  logbeta   <- par[75];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN71P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=71)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logscale  <- par[74];
                  logalpha  <- par[75];
                  logbeta   <- par[76];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN72P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=72)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logscale  <- par[75];
                  logalpha  <- par[76];
                  logbeta   <- par[77];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN73P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=73)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logscale  <- par[76];
                  logalpha  <- par[77];
                  logbeta   <- par[78];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN74P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=74)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logscale  <- par[77];
                  logalpha  <- par[78];
                  logbeta   <- par[79];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN75P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=75)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  ind.P75   <- ifelse(1:sealen < (ts.P75-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logP75    <- par[77];
                  logscale  <- par[78];
                  logalpha  <- par[79];
                  logbeta   <- par[80];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) +
                                 ind.P75[i]*exp(logP75)*exp(-exp(logM)*(i-(ts.P75-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN76P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=76)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.P76    <- dates[77];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  ind.P75   <- ifelse(1:sealen < (ts.P75-ts.start), 0, 1);
                  ind.P76   <- ifelse(1:sealen < (ts.P76-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logP75    <- par[77];
                  logP76    <- par[78];
                  logscale  <- par[79];
                  logalpha  <- par[80];
                  logbeta   <- par[81];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) +
                                 ind.P75[i]*exp(logP75)*exp(-exp(logM)*(i-(ts.P75-ts.start)+1)) +
                                 ind.P76[i]*exp(logP76)*exp(-exp(logM)*(i-(ts.P76-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN77P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=77)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.P76    <- dates[77];
                  ts.P77    <- dates[78];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  ind.P75   <- ifelse(1:sealen < (ts.P75-ts.start), 0, 1);
                  ind.P76   <- ifelse(1:sealen < (ts.P76-ts.start), 0, 1);
                  ind.P77   <- ifelse(1:sealen < (ts.P77-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logP75    <- par[77];
                  logP76    <- par[78];
                  logP77    <- par[79];
                  logscale  <- par[80];
                  logalpha  <- par[81];
                  logbeta   <- par[82];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) +
                                 ind.P75[i]*exp(logP75)*exp(-exp(logM)*(i-(ts.P75-ts.start)+1)) +
                                 ind.P76[i]*exp(logP76)*exp(-exp(logM)*(i-(ts.P76-ts.start)+1)) +
                                 ind.P77[i]*exp(logP77)*exp(-exp(logM)*(i-(ts.P77-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN78P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=78)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.P76    <- dates[77];
                  ts.P77    <- dates[78];
                  ts.P78    <- dates[79];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  ind.P75   <- ifelse(1:sealen < (ts.P75-ts.start), 0, 1);
                  ind.P76   <- ifelse(1:sealen < (ts.P76-ts.start), 0, 1);
                  ind.P77   <- ifelse(1:sealen < (ts.P77-ts.start), 0, 1);
                  ind.P78   <- ifelse(1:sealen < (ts.P78-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logP75    <- par[77];
                  logP76    <- par[78];
                  logP77    <- par[79];
                  logP78    <- par[80];
                  logscale  <- par[81];
                  logalpha  <- par[82];
                  logbeta   <- par[83];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) +
                                 ind.P75[i]*exp(logP75)*exp(-exp(logM)*(i-(ts.P75-ts.start)+1)) +
                                 ind.P76[i]*exp(logP76)*exp(-exp(logM)*(i-(ts.P76-ts.start)+1)) +
                                 ind.P77[i]*exp(logP77)*exp(-exp(logM)*(i-(ts.P77-ts.start)+1)) +
                                 ind.P78[i]*exp(logP78)*exp(-exp(logM)*(i-(ts.P78-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN79P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=79)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.P76    <- dates[77];
                  ts.P77    <- dates[78];
                  ts.P78    <- dates[79];
                  ts.P79    <- dates[80];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-ts.start), 0, 1);
                  ind.P47   <- ifelse(1:sealen < (ts.P47-ts.start), 0, 1);
                  ind.P48   <- ifelse(1:sealen < (ts.P48-ts.start), 0, 1);
                  ind.P49   <- ifelse(1:sealen < (ts.P49-ts.start), 0, 1);
                  ind.P50   <- ifelse(1:sealen < (ts.P50-ts.start), 0, 1);
                  ind.P51   <- ifelse(1:sealen < (ts.P51-ts.start), 0, 1);
                  ind.P52   <- ifelse(1:sealen < (ts.P52-ts.start), 0, 1);
                  ind.P53   <- ifelse(1:sealen < (ts.P53-ts.start), 0, 1);
                  ind.P54   <- ifelse(1:sealen < (ts.P54-ts.start), 0, 1);
                  ind.P55   <- ifelse(1:sealen < (ts.P55-ts.start), 0, 1);
                  ind.P56   <- ifelse(1:sealen < (ts.P56-ts.start), 0, 1);
                  ind.P57   <- ifelse(1:sealen < (ts.P57-ts.start), 0, 1);
                  ind.P58   <- ifelse(1:sealen < (ts.P58-ts.start), 0, 1);
                  ind.P59   <- ifelse(1:sealen < (ts.P59-ts.start), 0, 1);
                  ind.P60   <- ifelse(1:sealen < (ts.P60-ts.start), 0, 1);
                  ind.P61   <- ifelse(1:sealen < (ts.P61-ts.start), 0, 1);
                  ind.P62   <- ifelse(1:sealen < (ts.P62-ts.start), 0, 1);
                  ind.P63   <- ifelse(1:sealen < (ts.P63-ts.start), 0, 1);
                  ind.P64   <- ifelse(1:sealen < (ts.P64-ts.start), 0, 1);
                  ind.P65   <- ifelse(1:sealen < (ts.P65-ts.start), 0, 1);
                  ind.P66   <- ifelse(1:sealen < (ts.P66-ts.start), 0, 1);
                  ind.P67   <- ifelse(1:sealen < (ts.P67-ts.start), 0, 1);
                  ind.P68   <- ifelse(1:sealen < (ts.P68-ts.start), 0, 1);
                  ind.P69   <- ifelse(1:sealen < (ts.P69-ts.start), 0, 1);
                  ind.P70   <- ifelse(1:sealen < (ts.P70-ts.start), 0, 1);
                  ind.P71   <- ifelse(1:sealen < (ts.P71-ts.start), 0, 1);
                  ind.P72   <- ifelse(1:sealen < (ts.P72-ts.start), 0, 1);
                  ind.P73   <- ifelse(1:sealen < (ts.P73-ts.start), 0, 1);
                  ind.P74   <- ifelse(1:sealen < (ts.P74-ts.start), 0, 1);
                  ind.P75   <- ifelse(1:sealen < (ts.P75-ts.start), 0, 1);
                  ind.P76   <- ifelse(1:sealen < (ts.P76-ts.start), 0, 1);
                  ind.P77   <- ifelse(1:sealen < (ts.P77-ts.start), 0, 1);
                  ind.P78   <- ifelse(1:sealen < (ts.P78-ts.start), 0, 1);
                  ind.P79   <- ifelse(1:sealen < (ts.P79-ts.start), 0, 1);
                  logM      <- par[1];
                  logN0     <- par[2];
                  logP1     <- par[3];
                  logP2     <- par[4];
                  logP3     <- par[5];
                  logP4     <- par[6];
                  logP5     <- par[7];
                  logP6     <- par[8];
                  logP7     <- par[9];
                  logP8     <- par[10];
                  logP9     <- par[11];
                  logP10    <- par[12];
                  logP11    <- par[13];
                  logP12    <- par[14];
                  logP13    <- par[15];
                  logP14    <- par[16];
                  logP15    <- par[17];
                  logP16    <- par[18];
                  logP17    <- par[19];
                  logP18    <- par[20];
                  logP19    <- par[21];
                  logP20    <- par[22];
                  logP21    <- par[23];
                  logP22    <- par[24];
                  logP23    <- par[25];
                  logP24    <- par[26];
                  logP25    <- par[27];
                  logP26    <- par[28];
                  logP27    <- par[29];
                  logP28    <- par[30];
                  logP29    <- par[31];
                  logP30    <- par[32];
                  logP31    <- par[33];
                  logP32    <- par[34];
                  logP33    <- par[35];
                  logP34    <- par[36];
                  logP35    <- par[37];
                  logP36    <- par[38];
                  logP37    <- par[39];
                  logP38    <- par[40];
                  logP39    <- par[41];
                  logP40    <- par[42];
                  logP41    <- par[43];
                  logP42    <- par[44];
                  logP43    <- par[45];
                  logP44    <- par[46];
                  logP45    <- par[47];
                  logP46    <- par[48];
                  logP47    <- par[49];
                  logP48    <- par[50];
                  logP49    <- par[51];
                  logP50    <- par[52];
                  logP51    <- par[53];
                  logP52    <- par[54];
                  logP53    <- par[55];
                  logP54    <- par[56];
                  logP55    <- par[57];
                  logP56    <- par[58];
                  logP57    <- par[59];
                  logP58    <- par[60];
                  logP59    <- par[61];
                  logP60    <- par[62];
                  logP61    <- par[63];
                  logP62    <- par[64];
                  logP63    <- par[65];
                  logP64    <- par[66];
                  logP65    <- par[67];
                  logP66    <- par[68];
                  logP67    <- par[69];
                  logP68    <- par[70];
                  logP69    <- par[71];
                  logP70    <- par[72];
                  logP71    <- par[73];
                  logP72    <- par[74];
                  logP73    <- par[75];
                  logP74    <- par[76];
                  logP75    <- par[77];
                  logP76    <- par[78];
                  logP77    <- par[79];
                  logP78    <- par[80];
                  logP79    <- par[81];
                  logscale  <- par[82];
                  logalpha  <- par[83];
                  logbeta   <- par[84];
                  mccum[1]  <- 0;
                  nstep[1]  <- exp(logN0)*exp(-exp(logM));
                  for(i in 2:sealen)
                     {
                     mccum[i] <- obscat1[i-1] + mccum[i-1]*exp(-exp(logM));
                     nstep[i] <- exp(logN0)*exp(-exp(logM)*i) +
                                 ind.P1[i]*exp(logP1)*exp(-exp(logM)*(i-(ts.P1-ts.start)+1)) +
                                 ind.P2[i]*exp(logP2)*exp(-exp(logM)*(i-(ts.P2-ts.start)+1)) +
                                 ind.P3[i]*exp(logP3)*exp(-exp(logM)*(i-(ts.P3-ts.start)+1)) +
                                 ind.P4[i]*exp(logP4)*exp(-exp(logM)*(i-(ts.P4-ts.start)+1)) +
                                 ind.P5[i]*exp(logP5)*exp(-exp(logM)*(i-(ts.P5-ts.start)+1)) +
                                 ind.P6[i]*exp(logP6)*exp(-exp(logM)*(i-(ts.P6-ts.start)+1)) +
                                 ind.P7[i]*exp(logP7)*exp(-exp(logM)*(i-(ts.P7-ts.start)+1)) +
                                 ind.P8[i]*exp(logP8)*exp(-exp(logM)*(i-(ts.P8-ts.start)+1)) +
                                 ind.P9[i]*exp(logP9)*exp(-exp(logM)*(i-(ts.P9-ts.start)+1)) +
                                 ind.P10[i]*exp(logP10)*exp(-exp(logM)*(i-(ts.P10-ts.start)+1)) +
                                 ind.P11[i]*exp(logP11)*exp(-exp(logM)*(i-(ts.P11-ts.start)+1)) +
                                 ind.P12[i]*exp(logP12)*exp(-exp(logM)*(i-(ts.P12-ts.start)+1)) +
                                 ind.P13[i]*exp(logP13)*exp(-exp(logM)*(i-(ts.P13-ts.start)+1)) +
                                 ind.P14[i]*exp(logP14)*exp(-exp(logM)*(i-(ts.P14-ts.start)+1)) +
                                 ind.P15[i]*exp(logP15)*exp(-exp(logM)*(i-(ts.P15-ts.start)+1)) +
                                 ind.P16[i]*exp(logP16)*exp(-exp(logM)*(i-(ts.P16-ts.start)+1)) +
                                 ind.P17[i]*exp(logP17)*exp(-exp(logM)*(i-(ts.P17-ts.start)+1)) +
                                 ind.P18[i]*exp(logP18)*exp(-exp(logM)*(i-(ts.P18-ts.start)+1)) +
                                 ind.P19[i]*exp(logP19)*exp(-exp(logM)*(i-(ts.P19-ts.start)+1)) +
                                 ind.P20[i]*exp(logP20)*exp(-exp(logM)*(i-(ts.P20-ts.start)+1)) +
                                 ind.P21[i]*exp(logP21)*exp(-exp(logM)*(i-(ts.P21-ts.start)+1)) +
                                 ind.P22[i]*exp(logP22)*exp(-exp(logM)*(i-(ts.P22-ts.start)+1)) +
                                 ind.P23[i]*exp(logP23)*exp(-exp(logM)*(i-(ts.P23-ts.start)+1)) +
                                 ind.P24[i]*exp(logP24)*exp(-exp(logM)*(i-(ts.P24-ts.start)+1)) +
                                 ind.P25[i]*exp(logP25)*exp(-exp(logM)*(i-(ts.P25-ts.start)+1)) +
                                 ind.P26[i]*exp(logP26)*exp(-exp(logM)*(i-(ts.P26-ts.start)+1)) +
                                 ind.P27[i]*exp(logP27)*exp(-exp(logM)*(i-(ts.P27-ts.start)+1)) +
                                 ind.P28[i]*exp(logP28)*exp(-exp(logM)*(i-(ts.P28-ts.start)+1)) +
                                 ind.P29[i]*exp(logP29)*exp(-exp(logM)*(i-(ts.P29-ts.start)+1)) +
                                 ind.P30[i]*exp(logP30)*exp(-exp(logM)*(i-(ts.P30-ts.start)+1)) +
                                 ind.P31[i]*exp(logP31)*exp(-exp(logM)*(i-(ts.P31-ts.start)+1)) +
                                 ind.P32[i]*exp(logP32)*exp(-exp(logM)*(i-(ts.P32-ts.start)+1)) +
                                 ind.P33[i]*exp(logP33)*exp(-exp(logM)*(i-(ts.P33-ts.start)+1)) +
                                 ind.P34[i]*exp(logP34)*exp(-exp(logM)*(i-(ts.P34-ts.start)+1)) +
                                 ind.P35[i]*exp(logP35)*exp(-exp(logM)*(i-(ts.P35-ts.start)+1)) +
                                 ind.P36[i]*exp(logP36)*exp(-exp(logM)*(i-(ts.P36-ts.start)+1)) +
                                 ind.P37[i]*exp(logP37)*exp(-exp(logM)*(i-(ts.P37-ts.start)+1)) +
                                 ind.P38[i]*exp(logP38)*exp(-exp(logM)*(i-(ts.P38-ts.start)+1)) +
                                 ind.P39[i]*exp(logP39)*exp(-exp(logM)*(i-(ts.P39-ts.start)+1)) +
                                 ind.P40[i]*exp(logP40)*exp(-exp(logM)*(i-(ts.P40-ts.start)+1)) +
                                 ind.P41[i]*exp(logP41)*exp(-exp(logM)*(i-(ts.P41-ts.start)+1)) +
                                 ind.P42[i]*exp(logP42)*exp(-exp(logM)*(i-(ts.P42-ts.start)+1)) +
                                 ind.P43[i]*exp(logP43)*exp(-exp(logM)*(i-(ts.P43-ts.start)+1)) +
                                 ind.P44[i]*exp(logP44)*exp(-exp(logM)*(i-(ts.P44-ts.start)+1)) +
                                 ind.P45[i]*exp(logP45)*exp(-exp(logM)*(i-(ts.P45-ts.start)+1)) +
                                 ind.P46[i]*exp(logP46)*exp(-exp(logM)*(i-(ts.P46-ts.start)+1)) +
                                 ind.P47[i]*exp(logP47)*exp(-exp(logM)*(i-(ts.P47-ts.start)+1)) +
                                 ind.P48[i]*exp(logP48)*exp(-exp(logM)*(i-(ts.P48-ts.start)+1)) +
                                 ind.P49[i]*exp(logP49)*exp(-exp(logM)*(i-(ts.P49-ts.start)+1)) +
                                 ind.P50[i]*exp(logP50)*exp(-exp(logM)*(i-(ts.P50-ts.start)+1)) +
                                 ind.P51[i]*exp(logP51)*exp(-exp(logM)*(i-(ts.P51-ts.start)+1)) +
                                 ind.P52[i]*exp(logP52)*exp(-exp(logM)*(i-(ts.P52-ts.start)+1)) +
                                 ind.P53[i]*exp(logP53)*exp(-exp(logM)*(i-(ts.P53-ts.start)+1)) +
                                 ind.P54[i]*exp(logP54)*exp(-exp(logM)*(i-(ts.P54-ts.start)+1)) +
                                 ind.P55[i]*exp(logP55)*exp(-exp(logM)*(i-(ts.P55-ts.start)+1)) +
                                 ind.P56[i]*exp(logP56)*exp(-exp(logM)*(i-(ts.P56-ts.start)+1)) +
                                 ind.P57[i]*exp(logP57)*exp(-exp(logM)*(i-(ts.P57-ts.start)+1)) +
                                 ind.P58[i]*exp(logP58)*exp(-exp(logM)*(i-(ts.P58-ts.start)+1)) +
                                 ind.P59[i]*exp(logP59)*exp(-exp(logM)*(i-(ts.P59-ts.start)+1)) +
                                 ind.P60[i]*exp(logP60)*exp(-exp(logM)*(i-(ts.P60-ts.start)+1)) +
                                 ind.P61[i]*exp(logP61)*exp(-exp(logM)*(i-(ts.P61-ts.start)+1)) +
                                 ind.P62[i]*exp(logP62)*exp(-exp(logM)*(i-(ts.P62-ts.start)+1)) +
                                 ind.P63[i]*exp(logP63)*exp(-exp(logM)*(i-(ts.P63-ts.start)+1)) +
                                 ind.P64[i]*exp(logP64)*exp(-exp(logM)*(i-(ts.P64-ts.start)+1)) +
                                 ind.P65[i]*exp(logP65)*exp(-exp(logM)*(i-(ts.P65-ts.start)+1)) +
                                 ind.P66[i]*exp(logP66)*exp(-exp(logM)*(i-(ts.P66-ts.start)+1)) +
                                 ind.P67[i]*exp(logP67)*exp(-exp(logM)*(i-(ts.P67-ts.start)+1)) +
                                 ind.P68[i]*exp(logP68)*exp(-exp(logM)*(i-(ts.P68-ts.start)+1)) +
                                 ind.P69[i]*exp(logP69)*exp(-exp(logM)*(i-(ts.P69-ts.start)+1)) +
                                 ind.P70[i]*exp(logP70)*exp(-exp(logM)*(i-(ts.P70-ts.start)+1)) +
                                 ind.P71[i]*exp(logP71)*exp(-exp(logM)*(i-(ts.P71-ts.start)+1)) +
                                 ind.P72[i]*exp(logP72)*exp(-exp(logM)*(i-(ts.P72-ts.start)+1)) +
                                 ind.P73[i]*exp(logP73)*exp(-exp(logM)*(i-(ts.P73-ts.start)+1)) +
                                 ind.P74[i]*exp(logP74)*exp(-exp(logM)*(i-(ts.P74-ts.start)+1)) +
                                 ind.P75[i]*exp(logP75)*exp(-exp(logM)*(i-(ts.P75-ts.start)+1)) +
                                 ind.P76[i]*exp(logP76)*exp(-exp(logM)*(i-(ts.P76-ts.start)+1)) +
                                 ind.P77[i]*exp(logP77)*exp(-exp(logM)*(i-(ts.P77-ts.start)+1)) +
                                 ind.P78[i]*exp(logP78)*exp(-exp(logM)*(i-(ts.P78-ts.start)+1)) +
                                 ind.P79[i]*exp(logP79)*exp(-exp(logM)*(i-(ts.P79-ts.start)+1)) -
                                 mccum[i]*exp(-exp(logM)/2);
                     }
                  effeff1     <- obseff1^(exp(logalpha));
                  effn1       <- nstep^(exp(logbeta));
                  predcat1    <- exp(logscale)*(effeff1*effn1)*exp(-exp(logM)/2);
                  Likel       <- .CatDynLik(obscat1,predcat1,distr,npar=length(par))
                  if(output == "predict")
                    {
                    catdynexp <- .CatDynExp1F.Res(properties,nstep,obsmbm1,pp,dates,distr,par,Likel,ts.start,ts.end,obseff1,obscat1,predcat1)
                    class(catdynexp) <- "CatDynExp";
                    return(catdynexp);
                    }
                  else
                    {
                     if(distr == "apnormal" | distr == "aplnormal")
                       {
                        negsup <- ((sealen-2)/2)*log(sum(Likel[["Likelihood"]]));
                       }
                     else
                       {
                        negsup <- -sum(Likel[["Likelihood"]]);
                       }
                     return(negsup);
                    }
 }
.CDMN80P <-
function(par,dates,obscat1,obseff1,obsmbm1,distr,properties,output,pp=80)
  {
                  ts.start  <- head(dates,1);
                  ts.P1     <- dates[2];
                  ts.P2     <- dates[3];
                  ts.P3     <- dates[4];
                  ts.P4     <- dates[5];
                  ts.P5     <- dates[6];
                  ts.P6     <- dates[7];
                  ts.P7     <- dates[8];
                  ts.P8     <- dates[9];
                  ts.P9     <- dates[10];
                  ts.P10    <- dates[11];
                  ts.P11    <- dates[12];
                  ts.P12    <- dates[13];
                  ts.P13    <- dates[14];
                  ts.P14    <- dates[15];
                  ts.P15    <- dates[16];
                  ts.P16    <- dates[17];
                  ts.P17    <- dates[18];
                  ts.P18    <- dates[19];
                  ts.P19    <- dates[20];
                  ts.P20    <- dates[21];
                  ts.P21    <- dates[22];
                  ts.P22    <- dates[23];
                  ts.P23    <- dates[24];
                  ts.P24    <- dates[25];
                  ts.P25    <- dates[26];
                  ts.P26    <- dates[27];
                  ts.P27    <- dates[28];
                  ts.P28    <- dates[29];
                  ts.P29    <- dates[30];
                  ts.P30    <- dates[31];
                  ts.P31    <- dates[32];
                  ts.P32    <- dates[33];
                  ts.P33    <- dates[34];
                  ts.P34    <- dates[35];
                  ts.P35    <- dates[36];
                  ts.P36    <- dates[37];
                  ts.P37    <- dates[38];
                  ts.P38    <- dates[39];
                  ts.P39    <- dates[40];
                  ts.P40    <- dates[41];
                  ts.P41    <- dates[42];
                  ts.P42    <- dates[43];
                  ts.P43    <- dates[44];
                  ts.P44    <- dates[45];
                  ts.P45    <- dates[46];
                  ts.P46    <- dates[47];
                  ts.P47    <- dates[48];
                  ts.P48    <- dates[49];
                  ts.P49    <- dates[50];
                  ts.P49    <- dates[50];
                  ts.P50    <- dates[51];
                  ts.P51    <- dates[52];
                  ts.P52    <- dates[53];
                  ts.P53    <- dates[54];
                  ts.P54    <- dates[55];
                  ts.P55    <- dates[56];
                  ts.P56    <- dates[57];
                  ts.P57    <- dates[58];
                  ts.P58    <- dates[59];
                  ts.P59    <- dates[60];
                  ts.P60    <- dates[61];
                  ts.P61    <- dates[62];
                  ts.P62    <- dates[63];
                  ts.P63    <- dates[64];
                  ts.P64    <- dates[65];
                  ts.P65    <- dates[66];
                  ts.P66    <- dates[67];
                  ts.P67    <- dates[68];
                  ts.P68    <- dates[69];
                  ts.P69    <- dates[70];
                  ts.P70    <- dates[71];
                  ts.P71    <- dates[72];
                  ts.P72    <- dates[73];
                  ts.P73    <- dates[74];
                  ts.P74    <- dates[75];
                  ts.P75    <- dates[76];
                  ts.P76    <- dates[77];
                  ts.P77    <- dates[78];
                  ts.P78    <- dates[79];
                  ts.P79    <- dates[80];
                  ts.P80    <- dates[81];
                  ts.end    <- tail(dates,1);
                  sealen    <- ts.end-ts.start+1;
                  nstep     <- vector("numeric",sealen);
                  mccum     <- vector("numeric",sealen);
                  effeff1   <- vector("numeric",sealen);
                  effn1     <- vector("numeric",sealen);
                  predcat1  <- vector("numeric",sealen);
                  ind.P1    <- ifelse(1:sealen < (ts.P1-ts.start), 0, 1);
                  ind.P2    <- ifelse(1:sealen < (ts.P2-ts.start), 0, 1);
                  ind.P3    <- ifelse(1:sealen < (ts.P3-ts.start), 0, 1);
                  ind.P4    <- ifelse(1:sealen < (ts.P4-ts.start), 0, 1);
                  ind.P5    <- ifelse(1:sealen < (ts.P5-ts.start), 0, 1);
                  ind.P6    <- ifelse(1:sealen < (ts.P6-ts.start), 0, 1);
                  ind.P7    <- ifelse(1:sealen < (ts.P7-ts.start), 0, 1);
                  ind.P8    <- ifelse(1:sealen < (ts.P8-ts.start), 0, 1);
                  ind.P9    <- ifelse(1:sealen < (ts.P9-ts.start), 0, 1);
                  ind.P10   <- ifelse(1:sealen < (ts.P10-ts.start), 0, 1);
                  ind.P11   <- ifelse(1:sealen < (ts.P11-ts.start), 0, 1);
                  ind.P12   <- ifelse(1:sealen < (ts.P12-ts.start), 0, 1);
                  ind.P13   <- ifelse(1:sealen < (ts.P13-ts.start), 0, 1);
                  ind.P14   <- ifelse(1:sealen < (ts.P14-ts.start), 0, 1);
                  ind.P15   <- ifelse(1:sealen < (ts.P15-ts.start), 0, 1);
                  ind.P16   <- ifelse(1:sealen < (ts.P16-ts.start), 0, 1);
                  ind.P17   <- ifelse(1:sealen < (ts.P17-ts.start), 0, 1);
                  ind.P18   <- ifelse(1:sealen < (ts.P18-ts.start), 0, 1);
                  ind.P19   <- ifelse(1:sealen < (ts.P19-ts.start), 0, 1);
                  ind.P20   <- ifelse(1:sealen < (ts.P20-ts.start), 0, 1);
                  ind.P21   <- ifelse(1:sealen < (ts.P21-ts.start), 0, 1);
                  ind.P22   <- ifelse(1:sealen < (ts.P22-ts.start), 0, 1);
                  ind.P23   <- ifelse(1:sealen < (ts.P23-ts.start), 0, 1);
                  ind.P24   <- ifelse(1:sealen < (ts.P24-ts.start), 0, 1);
                  ind.P25   <- ifelse(1:sealen < (ts.P25-ts.start), 0, 1);
                  ind.P26   <- ifelse(1:sealen < (ts.P26-ts.start), 0, 1);
                  ind.P27   <- ifelse(1:sealen < (ts.P27-ts.start), 0, 1);
                  ind.P28   <- ifelse(1:sealen < (ts.P28-ts.start), 0, 1);
                  ind.P29   <- ifelse(1:sealen < (ts.P29-ts.start), 0, 1);
                  ind.P30   <- ifelse(1:sealen < (ts.P30-ts.start), 0, 1);
                  ind.P31   <- ifelse(1:sealen < (ts.P31-ts.start), 0, 1);
                  ind.P32   <- ifelse(1:sealen < (ts.P32-ts.start), 0, 1);
                  ind.P33   <- ifelse(1:sealen < (ts.P33-ts.start), 0, 1);
                  ind.P34   <- ifelse(1:sealen < (ts.P34-ts.start), 0, 1);
                  ind.P35   <- ifelse(1:sealen < (ts.P35-ts.start), 0, 1);
                  ind.P36   <- ifelse(1:sealen < (ts.P36-ts.start), 0, 1);
                  ind.P37   <- ifelse(1:sealen < (ts.P37-ts.start), 0, 1);
                  ind.P38   <- ifelse(1:sealen < (ts.P38-ts.start), 0, 1);
                  ind.P39   <- ifelse(1:sealen < (ts.P39-ts.start), 0, 1);
                  ind.P40   <- ifelse(1:sealen < (ts.P40-ts.start), 0, 1);
                  ind.P41   <- ifelse(1:sealen < (ts.P41-ts.start), 0, 1);
                  ind.P42   <- ifelse(1:sealen < (ts.P42-ts.start), 0, 1);
                  ind.P43   <- ifelse(1:sealen < (ts.P43-ts.start), 0, 1);
                  ind.P44   <- ifelse(1:sealen < (ts.P44-ts.start), 0, 1);
                  ind.P45   <- ifelse(1:sealen < (ts.P45-ts.start), 0, 1);
                  ind.P46   <- ifelse(1:sealen < (ts.P46-t