% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc_provinces.R
\name{catr_ovc_get_cod_provinces}
\alias{catr_ovc_get_cod_provinces}
\title{OVCCallejero: Extract a list of provinces with their codes}
\usage{
catr_ovc_get_cod_provinces(verbose = FALSE)
}
\arguments{
\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{\link[tibble:tibble]{tibble}}.
}
\description{
Implementation of the OVCCallejero service
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccallejerocodigos.asmx?op=ConsultaProvincia}{ConsultaProvincia}.

Return a list of the provinces included on the Spanish Cadastre.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

catr_ovc_get_cod_provinces()
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccallejerocodigos.asmx?op=ConsultaProvincia}{ConsultaProvincia}.
}
\seealso{
OVCCoordenadas API:
\code{\link{catr_ovc_get_cod_munic}()}

Other search: 
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_get_code_from_coords}()},
\code{\link{catr_ovc_get_cod_munic}()}
}
\concept{OVCCallejero}
\concept{search}
