% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/synthetize.R
\name{simulateWitnessModel}
\alias{simulateWitnessModel}
\title{Generates Synthetic CausalFX Problems}
\usage{
simulateWitnessModel(p, q, par_max, M, no_sol = FALSE)
}
\arguments{
\item{p}{number of background variables (besides \eqn{X} and \eqn{Y}).}

\item{q}{number of sink variables.}

\item{par_max}{maximum number of parents in the background set.}

\item{M}{sample size.}

\item{no_sol}{if \code{TRUE}, then latent variables are parents of both \eqn{X}
              and \eqn{Y}, meaning no adjustment set will theoretically be found
              (barring sampling variability) if a method such as \code{\link{covsearch}}
              is applied.}
}
\value{
An object of class \code{\link{cfx}}.
}
\description{
This function generates simple synthetic problems that can be used to test
the methods in the \code{CausalFX} package. \code{CausalFX} problems are objects
of class \code{\link{cfx}}, and specify a causal inference task of estimating the effect
of a given treatment \eqn{X} on a given outcome \eqn{Y}, with a corresponding dataset.
This function generates only binary data from a multinomial distribution.
}
\details{
The function first generates a directed acyclic graph with a given number of variables which have no latent common
parents with treatment \eqn{X} and outcome \eqn{Y}, which we call "background variables". Conditioning
on a subset of the background variables will block all measured confounding in this problem.
The function then generates a set of "sink" variables \eqn{K} which have one common latent parent with
either \eqn{X} or \eqn{Y}, but are otherwise not adjacent to any observed variable. Conditioning on the sink variables
will generate confounding paths between treatment and outcome. Latent variables are
a  pool of independent variables with no parents. If \code{no_sol} is \code{FALSE}, they are parents of either \eqn{X} or \eqn{Y} but not both.
If \code{no_sol} is \code{TRUE}, then all latent variables are parents of both \eqn{X} and \eqn{Y} and as
such no adjustment set with observed variables will remove unmeasured confounding between treatment and outcome.
Remaining parents for observed variables are sampled uniformly at random from the pool of background
variables obeying the constraint on the maximum number of parents given by \code{par_max}.

Given a graph structure, each variable \eqn{i} is given a binary conditional distribution, defining the probability
of \eqn{i} being equal to 1 given its parents in the graph. This conditional distribution is generated
randomly by a logistic regression model with pairwise interactions, where coefficients are generated by
samples from independent Gaussians with zero mean and standard deviation 10 / number of parents.
}

