% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{get_data_families}
\alias{get_data_families}
\title{get_data_families}
\usage{
get_data_families(
  model,
  drop_impossible = TRUE,
  drop_all_NA = TRUE,
  mapping_only = FALSE
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{drop_impossible}{Logical. Whether to drop data that is impossible given model restrictions. Defaults to `TRUE`.}

\item{drop_all_NA}{Logical. Whether to drop row of all `NA`s. Defaults to `TRUE`}

\item{mapping_only}{Logical. Whether to return data mapping matrix only. Defaults to `FALSE`.}
}
\value{
Returns indices and ambiguity matrix
}
\description{
Get possible data types
}
\examples{
\donttest{
CausalQueries:::get_data_families(model = make_model('X->Y'))
CausalQueries:::get_data_families(model = make_model('X->Y'), mapping_only = TRUE)
CausalQueries:::get_data_families(model = make_model('X-> M -> Y'))

}
}
\keyword{internal}
