% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{spec_regress}
\alias{spec_regress}
\title{Fisher Scoring Algorithm For Estimating Cepstral Coefficients}
\usage{
spec_regress(perd, psi, Wmat, k0)
}
\arguments{
\item{perd}{An N x K matrix of periodogram.}

\item{psi}{A matrix of cepstral basis functions of dimension \code{k0 × K}.}

\item{Wmat}{The inverse Gram matrix of the basis functions.}

\item{k0}{Number of cepstral basis function}
}
\value{
A list with:
\describe{
\item{\code{f}}{An \code{N × k0} matrix of estimated cepstral coefficients.}
\item{\code{ff}}{An \code{N × K} matrix of smoothed log-spectra.}
}
}
\description{
Estimates replicate-specific cepstral coefficients and corresponding smoothed log-spectra
using a Whittle likelihood approximation.
}
\examples{
set.seed(123)
N <- 5
len <- 20
L <- floor(len/2) - 1
frq <- (1:L) / len

Y <- matrix(rnorm(len * N), nrow = len, ncol = N)

perd <- perd_get(Y)

k0 <- 3
psi <- psi_get(k0, frq)

Wmatin <- matrix(0, k0, k0)
for (j in 1:ncol(psi)) {
  Wmatin <- Wmatin + psi[, j] \%*\% t(psi[, j])
}
Wmat <- solve(Wmatin)

out <- spec_regress(perd, psi, Wmat, k0)
}
