% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.r
\name{NlmeJobStatus}
\alias{NlmeJobStatus}
\title{Reads progress file and returns the status of a job}
\usage{
NlmeJobStatus(job)
}
\arguments{
\item{job}{NLME job object}
}
\value{
Character. Job status messages.
}
\description{
Reads progress file and returns the status of a job
}
\examples{
\donttest{
  param <- NlmeEngineExtraParams(
    method = 3,
    numIterations = 1000
  )

  profile1 <- ProfileVar("tvV", 9.548, "-2,-1,0,1,2")
  profile2 <- ProfileVar("tvCl", 0.919, "-0.5,0,1.5")
  profiles <- ProfileParameters("USE_DELTA", c(profile1, profile2))

  job <- profilePertubate(defaultHost, params, profiles, model)
  status <- NlmeJobStatus(job)
}
}
\keyword{internal}
