% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeParallelHost.R
\docType{class}
\name{NlmeParallelHost-class}
\alias{NlmeParallelHost-class}
\alias{NlmeParallelHost}
\title{NlmeParallelHost Class}
\description{
This class defines an NLME parallel host, which can be either local or
remote, for running jobs.
}
\section{Slots}{

\describe{
\item{\code{sharedDirectory}}{\code{character}. The directory where the run will take place.
On Windows, UNC paths are mapped to a drive letter for local execution.}

\item{\code{installationDirectory}}{\code{character}. The directory containing NLME
libraries and scripts.}

\item{\code{hostName}}{\code{character}. A user-friendly name for the host (e.g., "local_mpi").}

\item{\code{machineName}}{\code{character}. The IP address or hostname of the machine.
Defaults to the local system's node name.}

\item{\code{hostType}}{\code{character}. The operating system of the host, either
\code{"windows"} or \code{"linux"}. For remote Linux systems, you can specify a
supported distribution (e.g., \code{"RHEL"}, \code{"UBUNTU"}) to configure the
\code{PML_BIN_DIR} environment variable. \code{linux} will be treated as \code{"RHEL"}.}

\item{\code{numCores}}{\code{numeric}. The number of compute cores to be used.}

\item{\code{isLocal}}{\code{logical}. \code{TRUE} if the host is local, \code{FALSE} if remote.}

\item{\code{rLocation}}{\code{character}. The path to the Rscript executable on a remote
host. This is ignored for local runs.}

\item{\code{scriptPath}}{\code{character}. The path to a script to execute on the remote
host before Rscript is started. This is ignored for local runs.}

\item{\code{userAuthentication}}{\code{NlmeUserAuthentication}. An object containing user
credentials for remote host authentication. See \code{\link[=NlmeUserAuthentication]{NlmeUserAuthentication()}}.}

\item{\code{parallelMethod}}{\code{NlmeParallelMethod}. The parallel computing method to
use (e.g., \code{"LOCAL_MPI"}, \code{"SGE"}, \code{"TORQUE"}). See \code{\link[=NlmeParallelMethod]{NlmeParallelMethod()}}.}
}}

\examples{
host <- hostParams(
  parallelMethod = "LOCAL_MPI",
  hostName = "local_mpi",
  numCores = 4
)

}
\keyword{NLME}
\keyword{NlmeParallelHost}
\keyword{internal}
