% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSlice.R
\name{plotSlice}
\alias{plotSlice}
\title{Plot a Slice of a Spectra2D Object}
\usage{
plotSlice(spectra, which = 1, F2 = NULL, F1 = NULL, showGrid = TRUE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{which}{A single integer specifying which 2D spectrum from which to
plot the slice.}

\item{F2}{A single frequency to plot.  Matched to the nearest value.}

\item{F1}{As for \code{F2}.}

\item{showGrid}{Logical. If TRUE, show a dotted gray line at each x axis tick mark.}

\item{\ldots}{Additional parameters to be passed to the plotting routines.}
}
\value{
Side effect is a plot.
}
\description{
Plots a slice of a 2D spectrum stored in a \code{\link{Spectra2D}} object.
}
\section{Note}{

Only one of \code{F2} or \code{F1} should be given.
}

\examples{

data(MUD1)
plotSlice(MUD1, F1 = 22, main = "Slice @ F1 = 22 ppm")
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{hplot}
